/*
 * Decompiled with CFR 0.152.
 */
package koala;

import koala.KatanaCommsException;
import koala.KatanaLocation;
import koala.KatanaOutOfRangeException;
import koala.KoalaSensorReading;
import koala.RobotArm;

public class KatanaArm
implements RobotArm {
    private static KatanaArm arm = null;
    private static final int zAxialRotation = 5;
    public static final KatanaLocation TOP = KatanaArm.rotateAxes(new KatanaLocation(0.0, 0.0, 535.0));
    public static final KatanaLocation LEFT = KatanaArm.rotateAxes(new KatanaLocation(0.0, -535.0, 0.0));
    public static final KatanaLocation RIGHT = KatanaArm.rotateAxes(new KatanaLocation(0.0, 535.0, 0.0));
    public static final KatanaLocation INFRONT = KatanaArm.rotateAxes(new KatanaLocation(-200.0, 0.0, -300.0));

    public static KatanaArm getInstance() {
        String string = System.getProperty("os.name");
        if (!string.contains("Windows")) {
            System.err.println("KatanaARM requires jkatana.dll, only available on Windows.");
        }
        if (arm == null) {
            arm = new KatanaArm();
        }
        return arm;
    }

    private KatanaArm() {
        System.loadLibrary("jkatana");
        this.initialise(1);
        this.setMaximumSpeed(60.0);
    }

    public synchronized void disconnect() {
        this.shutdown();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    private synchronized native void initialise(int var1);

    private synchronized native void shutdown();

    public synchronized native void openGripper();

    public synchronized native void closeGripper();

    public synchronized native void calibrate();

    public synchronized native KoalaSensorReading readSensors();

    public synchronized native KoalaSensorReading readForceSensors();

    public synchronized native KoalaSensorReading readProximitySensors();

    public synchronized native int getGripperPosition() throws KatanaCommsException;

    public synchronized native boolean gripperClosed();

    public synchronized native boolean grippingSomething();

    public synchronized native double getMaximumSpeed();

    public synchronized native void setMaximumSpeed(double var1);

    public synchronized native int getMotorPosition(int var1);

    private synchronized native KatanaLocation getLocationN();

    public synchronized KatanaLocation getLocation() {
        KatanaLocation katanaLocation = this.getLocationN();
        return katanaLocation;
    }

    public synchronized native void moveTo(KatanaLocation var1) throws KatanaOutOfRangeException, KatanaCommsException;

    public synchronized native void moveToWithoutBlocking(KatanaLocation var1);

    public synchronized native void rotateWristTo(int var1) throws KatanaOutOfRangeException;

    public synchronized native void rotateMotorTo(int var1, int var2) throws KatanaOutOfRangeException;

    public synchronized native void moveToRestingPosition();

    public synchronized native void unblock();

    public synchronized boolean pickUp() {
        this.openGripper();
        try {
            this.rotateWristTo(180);
        }
        catch (KatanaOutOfRangeException katanaOutOfRangeException) {
            // empty catch block
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.moveTo(INFRONT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        KoalaSensorReading koalaSensorReading = arm.readSensors();
        if (koalaSensorReading.rightSensors[3] > 6) {
            arm.closeGripper();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return arm.grippingSomething();
        }
        return false;
    }

    public static KatanaLocation rotateAxes(KatanaLocation katanaLocation) {
        double d = Math.toRadians(5.0);
        double d2 = katanaLocation.x * Math.cos(d) + katanaLocation.y * Math.sin(d);
        double d3 = katanaLocation.y * Math.cos(d) - katanaLocation.x * Math.sin(d);
        return new KatanaLocation(d2, d3, katanaLocation.z);
    }

    private static void throwBall() throws Exception {
        if (arm.pickUp()) {
            arm.setMaximumSpeed(170.0);
            arm.moveToWithoutBlocking(new KatanaLocation(0.0, 0.0, 535.0));
            Thread.sleep(2000L);
            arm.openGripper();
            arm.setMaximumSpeed(60.0);
        } else {
            System.out.println("Couldn't find the ball");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        arm = KatanaArm.getInstance();
        arm.moveToRestingPosition();
        Thread.sleep(5000L);
        System.out.println("should be resting.");
        KatanaArm.throwBall();
    }
}

