/*
 * Decompiled with CFR 0.152.
 */
package koala;

import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KoalaImage {
    public static final int RED = 0xFF0000;
    public static final int GREEN = 65280;
    public static final int BLUE = 255;
    public static final int BLACK = 0;
    public static final int WHITE = 0xFFFFFF;
    public final int[] pixels;
    public final int width;
    public final int height;

    public KoalaImage(Image image) {
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        bufferedImage.createGraphics().drawImage(image, null, null);
        this.pixels = new int[this.width * this.height];
        bufferedImage.getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
    }

    public KoalaImage(int[] nArray, int n, int n2) {
        this.pixels = nArray;
        this.width = n;
        this.height = n2;
    }

    public void applyRedThreshold(int n, double d, double d2) {
        for (int i = 0; i < this.pixels.length; ++i) {
            if (KoalaImage.redPart(this.pixels[i]) <= n || !((double)KoalaImage.redPart(this.pixels[i]) > d * (double)KoalaImage.bluePart(this.pixels[i])) || !((double)KoalaImage.redPart(this.pixels[i]) > d2 * (double)KoalaImage.greenPart(this.pixels[i]))) continue;
            this.pixels[i] = 0xFF0000;
        }
    }

    public void applyBlueThreshold(int n, double d, double d2) {
        for (int i = 0; i < this.pixels.length; ++i) {
            if (KoalaImage.bluePart(this.pixels[i]) <= n || !((double)KoalaImage.bluePart(this.pixels[i]) > d * (double)KoalaImage.redPart(this.pixels[i])) || !((double)KoalaImage.bluePart(this.pixels[i]) > d2 * (double)KoalaImage.greenPart(this.pixels[i]))) continue;
            this.pixels[i] = 255;
        }
    }

    public void applyGreenThreshold(int n, double d, double d2) {
        for (int i = 0; i < this.pixels.length; ++i) {
            if (KoalaImage.greenPart(this.pixels[i]) <= n || !((double)KoalaImage.greenPart(this.pixels[i]) > d * (double)KoalaImage.bluePart(this.pixels[i])) || !((double)KoalaImage.greenPart(this.pixels[i]) > d2 * (double)KoalaImage.redPart(this.pixels[i]))) continue;
            this.pixels[i] = 65280;
        }
    }

    public void applyGreyThreshold(int n) {
        this.applyThreshold(Color.black, new int[]{0, n, 0, n, 0, n});
    }

    public void applyThreshold(Color color, int[] nArray) {
        int n = 0xFFFFFF & color.getRGB();
        for (int i = 0; i < this.pixels.length; ++i) {
            if (KoalaImage.redPart(this.pixels[i]) <= nArray[0] || KoalaImage.redPart(this.pixels[i]) >= nArray[1] || KoalaImage.bluePart(this.pixels[i]) <= nArray[4] || KoalaImage.bluePart(this.pixels[i]) >= nArray[5] || KoalaImage.greenPart(this.pixels[i]) <= nArray[2] || KoalaImage.greenPart(this.pixels[i]) >= nArray[3]) continue;
            this.pixels[i] = n;
        }
    }

    public Vector<Blob> getBlobs(Color color, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Vector<Blob> vector = new Vector<Blob>();
        int n7 = 0xFFFFFF & color.getRGB();
        int[] nArray = new int[this.pixels.length];
        int n8 = 1;
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        for (int i = 1; i < this.pixels.length; ++i) {
            if (this.pixels[i] != n7) continue;
            int n9 = i <= this.width ? 1 : 4;
            nArray2[0] = i - 1;
            nArray2[1] = i - this.width;
            nArray2[2] = i - this.width - 1;
            nArray2[3] = i - this.width + 1;
            int n10 = 0;
            for (n6 = 0; n6 < n9; ++n6) {
                if (this.pixels[nArray2[n6]] != n7) continue;
                nArray3[n10++] = n6;
            }
            if (n10 == 0) {
                nArray[i] = n8++;
                continue;
            }
            if (n10 == 1) {
                nArray[i] = nArray[nArray2[nArray3[0]]];
                continue;
            }
            n6 = 1;
            for (n5 = 0; n5 < n10; ++n5) {
                nArray4[n5] = nArray[nArray2[nArray3[n5]]];
                if (n5 <= 0) continue;
                n6 &= nArray4[n5] == nArray4[n5 - 1] ? 1 : 0;
            }
            nArray[i] = nArray4[0];
            if (n6 != 0) continue;
            for (n5 = 0; n5 < i; ++n5) {
                for (n4 = 1; n4 < n10; ++n4) {
                    if (nArray[n5] != nArray4[n4]) continue;
                    nArray[n5] = nArray4[0];
                }
            }
        }
        int[] nArray5 = new int[n8 + 1];
        for (n6 = 0; n6 < this.pixels.length; ++n6) {
            if (nArray[n6] == 0) continue;
            int n11 = nArray[n6];
            nArray5[n11] = nArray5[n11] + 1;
        }
        int[] nArray6 = new int[n2];
        for (n5 = 1; n5 < n8; ++n5) {
            if (nArray5[n5] <= n) continue;
            if (n2 == 0) {
                n4 = 0;
                n3 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n5) continue;
                    n4 += i % this.width;
                    n3 += i / this.width;
                }
                vector.add(new Blob(n4 / nArray5[n5], n3 / nArray5[n5], nArray5[n5]));
                continue;
            }
            if (n2 == 1 && nArray5[n5] > nArray5[nArray6[0]]) {
                nArray6[0] = n5;
                continue;
            }
            for (n4 = 0; n4 < n2 - 1; ++n4) {
                if (nArray5[nArray6[n4]] >= nArray5[n5] || n4 != 0 && nArray5[nArray6[n4 - 1]] <= nArray5[n5]) continue;
                for (n3 = n2 - 1; n3 > n4; --n3) {
                    nArray6[n3] = nArray6[n3 - 1];
                }
                nArray6[n4] = n5;
            }
        }
        if (n2 != 0) {
            for (n5 = 0; n5 < n2; ++n5) {
                if (nArray6[n5] == 0) continue;
                n4 = 0;
                n3 = 0;
                boolean[] blArray = new boolean[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != nArray6[n5]) continue;
                    n4 += i % this.width;
                    n3 += i / this.width;
                    blArray[i] = true;
                }
                if (n4 <= 0 || n3 <= 0) continue;
                Blob blob = new Blob(n4 / nArray5[nArray6[n5]], n3 / nArray5[nArray6[n5]], nArray5[nArray6[n5]]);
                blob.pixels = blArray;
                blob.imageWidth = this.width;
                blob.imageHeight = this.height;
                vector.add(blob);
            }
        }
        return vector;
    }

    public Blob getLargestBlob(Color color, int n) {
        Vector<Blob> vector = this.getBlobs(color, n, 1);
        if (vector.size() == 1) {
            return vector.elementAt(0);
        }
        return null;
    }

    public boolean isAbnormal() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.pixels.length; ++i) {
            if (KoalaImage.bluePart(this.pixels[i]) == 255) {
                ++n;
                continue;
            }
            if (this.pixels[i] != 0) continue;
            ++n2;
        }
        return n2 > this.pixels.length / 2 || n > this.pixels.length / 2;
    }

    public int[] getRedHistogram() {
        int[] nArray = new int[256];
        for (int i = 0; i < this.pixels.length; ++i) {
            int n = KoalaImage.redPart(this.pixels[i]);
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    public int[] getGreenHistogram() {
        int[] nArray = new int[256];
        for (int i = 0; i < this.pixels.length; ++i) {
            int n = KoalaImage.greenPart(this.pixels[i]);
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    public int[] getBlueHistogram() {
        int[] nArray = new int[256];
        for (int i = 0; i < this.pixels.length; ++i) {
            int n = KoalaImage.bluePart(this.pixels[i]);
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    public BufferedImage toImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        bufferedImage.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        return bufferedImage;
    }

    public static final int bluePart(int n) {
        return n & 0xFF;
    }

    public static final int greenPart(int n) {
        return (n & 0xFF00) >> 8;
    }

    public static final int redPart(int n) {
        return (n & 0xFF0000) >> 16;
    }

    public static class Blob
    extends Point {
        public int size;
        public int perimeter = -1;
        public boolean[] pixels;
        public int imageWidth;
        public int imageHeight;

        public Blob(int n, int n2, int n3) {
            super(n, n2);
            this.size = n3;
        }

        public int calculatePerimeter() {
            if (this.pixels == null) {
                return -1;
            }
            if (this.perimeter != -1) {
                return this.perimeter;
            }
            int n = 0;
            for (int i = 1; i < this.imageWidth - 1; ++i) {
                for (int j = 1; j < this.imageHeight - 1; ++j) {
                    if (!this.pixels[j * this.imageWidth + i] || this.pixels[(j - 1) * this.imageWidth + i] && this.pixels[(j + 1) * this.imageWidth + i] && this.pixels[j * this.imageWidth + (i - 1)] && this.pixels[j * this.imageWidth + (i + 1)]) continue;
                    ++n;
                }
            }
            this.perimeter = n;
            return n;
        }

        public double calculateCircularity() {
            return (double)this.calculatePerimeter() / (2.0 * Math.sqrt(Math.PI * (double)this.size));
        }
    }
}

