/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.util.Vector;
import koala.KoalaSensorReading;
import koala.KoalaSensors;
import koala.KoalaVector;
import koala.motion.MotionController;
import koala.motion.MotionSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObstacleAvoider
implements MotionSource,
TranquilComponent {
    @req(value="controller")
    public MotionController controller;
    @req(value="sensors")
    public KoalaSensors sensors;
    private final int obstacleThreshold = 150;

    public void startComponent() {
        System.out.println("ObstacleAvoider: Registering with motion controller.");
        this.controller.registerMotionSource(this, 50);
    }

    public void stopComponent() {
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
    }

    @Override
    public KoalaVector getDirection() {
        int n;
        KoalaSensorReading koalaSensorReading = this.sensors.readProximitySensors();
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < 3; ++n) {
            if (koalaSensorReading.leftSensors[n] > 150) {
                d += (double)(koalaSensorReading.leftSensors[n] * 1);
                d2 += 0.0;
            }
            if (koalaSensorReading.rightSensors[n] <= 150) continue;
            d += (double)(koalaSensorReading.rightSensors[n] * 1);
            d2 += 0.0;
        }
        if (koalaSensorReading.leftSensors[3] > 150) {
            d += (double)(koalaSensorReading.leftSensors[3] * 10) * Math.cos(Math.toRadians(45.0));
            d2 += (double)(koalaSensorReading.leftSensors[3] * 10) * Math.sin(Math.toRadians(45.0));
        }
        if (koalaSensorReading.rightSensors[3] > 150) {
            d += (double)(koalaSensorReading.rightSensors[3] * 10) * Math.cos(Math.toRadians(-45.0));
            d2 += (double)(koalaSensorReading.rightSensors[3] * 10) * Math.sin(Math.toRadians(-45.0));
        }
        for (n = 4; n < 6; ++n) {
            if (koalaSensorReading.leftSensors[n] > 150) {
                d += 0.0;
                d2 += (double)(koalaSensorReading.leftSensors[n] * 1);
            }
            if (koalaSensorReading.rightSensors[n] <= 150) continue;
            d += 0.0;
            d2 += (double)(koalaSensorReading.rightSensors[n] * -1);
        }
        if (koalaSensorReading.leftSensors[6] > 150) {
            d += (double)koalaSensorReading.leftSensors[6] * Math.cos(Math.toRadians(135.0));
            d2 += (double)koalaSensorReading.leftSensors[6] * Math.sin(Math.toRadians(135.0));
        }
        if (koalaSensorReading.rightSensors[6] > 150) {
            d += (double)koalaSensorReading.rightSensors[6] * Math.cos(Math.toRadians(-135.0));
            d2 += (double)koalaSensorReading.rightSensors[6] * Math.sin(Math.toRadians(-135.0));
        }
        if (koalaSensorReading.leftSensors[7] > 150) {
            d += (double)(koalaSensorReading.leftSensors[7] * -1);
            d2 += 0.0;
        }
        if (koalaSensorReading.rightSensors[7] > 150) {
            d += (double)(koalaSensorReading.rightSensors[7] * -1);
            d2 += 0.0;
        }
        KoalaVector koalaVector = new KoalaVector(-d, -d2);
        koalaVector.normalise();
        return koalaVector;
    }
}

