/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.util.Vector;
import koala.KoalaMotors;
import koala.KoalaVector;
import koala.motion.MotionController;
import koala.motion.MotionSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorMotionController
implements MotionController,
TranquilComponent {
    @req(value="motors")
    public KoalaMotors motors;
    public volatile Vector<MotionSource> sources = new Vector();
    private volatile Vector<Integer> weights = new Vector();
    private volatile boolean smoothTrajectory = true;
    private volatile int maxSpeed = 30;
    private VThread vThread;

    public void startComponent() {
        System.out.println("V: Starting.");
        if (this.vThread != null) {
            this.vThread.halt();
        }
        this.vThread = new VThread();
        this.vThread.start();
    }

    public void stopComponent() {
        System.out.println("V: Stopping.");
        if (this.vThread != null) {
            this.vThread.halt();
        }
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
    }

    @Override
    public void registerMotionSource(MotionSource motionSource) {
        this.registerMotionSource(motionSource, 1);
    }

    @Override
    public void registerMotionSource(MotionSource motionSource, int n) {
        if (!this.sources.contains(motionSource)) {
            this.sources.add(motionSource);
            this.weights.add(n);
        }
    }

    @Override
    public void deregisterMotionSource(MotionSource motionSource) {
        int n = this.sources.indexOf(motionSource);
        if (n != -1) {
            this.sources.remove(motionSource);
            this.weights.removeElementAt(n);
        }
    }

    @Override
    public KoalaVector getCurrentDirection() {
        KoalaVector koalaVector = new KoalaVector(0.0, 0.0);
        for (int i = 0; i < this.sources.size(); ++i) {
            try {
                KoalaVector koalaVector2 = this.sources.elementAt(i).getDirection();
                KoalaVector koalaVector3 = new KoalaVector(koalaVector2.x, koalaVector2.y);
                System.out.println("V:got " + koalaVector3 + " from " + this.sources.elementAt(i).getClass().getName());
                int n = this.weights.elementAt(i);
                koalaVector3.scale(n);
                koalaVector = koalaVector.add(koalaVector3);
                continue;
            }
            catch (Exception exception) {
                System.out.println("V:problem with motion source " + i);
            }
        }
        koalaVector.x /= (double)this.sources.size();
        koalaVector.y /= (double)this.sources.size();
        return koalaVector;
    }

    @Override
    public void setSmoothTrajectory(boolean bl) {
        this.smoothTrajectory = bl;
    }

    @Override
    public void setMaximumSpeed(int n) {
        this.maxSpeed = n;
    }

    protected void finalize() throws Throwable {
        this.motors.setSpeed(0, 0);
    }

    public class VThread
    extends Thread {
        private volatile boolean running = true;

        public void run() {
            while (this.running) {
                try {
                    if (VectorMotionController.this.sources.size() > 0) {
                        KoalaVector koalaVector = VectorMotionController.this.getCurrentDirection();
                        if (koalaVector.magnitude() > 0.01) {
                            int n = koalaVector.direction();
                            if (n > 180) {
                                n -= 360;
                            } else if (n < -180) {
                                n += 360;
                            }
                            if (VectorMotionController.this.smoothTrajectory) {
                                if (n > 0) {
                                    VectorMotionController.this.motors.setSpeed(VectorMotionController.this.maxSpeed - n * VectorMotionController.this.maxSpeed / 120, VectorMotionController.this.maxSpeed);
                                } else {
                                    VectorMotionController.this.motors.setSpeed(VectorMotionController.this.maxSpeed, VectorMotionController.this.maxSpeed + n * VectorMotionController.this.maxSpeed / 120);
                                }
                            } else {
                                if (Math.abs(n) > 1) {
                                    VectorMotionController.this.motors.rotate(n);
                                }
                                VectorMotionController.this.motors.setSpeed(VectorMotionController.this.maxSpeed, VectorMotionController.this.maxSpeed);
                            }
                        } else {
                            VectorMotionController.this.motors.setSpeed(0, 0);
                        }
                        Thread.sleep(250L);
                        continue;
                    }
                    Thread.sleep(750L);
                    VectorMotionController.this.motors.setSpeed(0, 0);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("VectorMotionController interrupted.");
                }
            }
            VectorMotionController.this.motors.setSpeed(0, 0);
        }

        public void halt() {
            this.running = false;
            try {
                VectorMotionController.this.vThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            VectorMotionController.this.motors.setSpeed(0, 0);
        }
    }
}

