/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.api.req;
import java.awt.Color;
import koala.Koala;
import koala.KoalaCamera;
import koala.KoalaImage;
import koala.KoalaVector;
import koala.motion.MotionSource;
import koala.remote.Webcam;
import koala.task.KoalaTask;

public class VisualFollowingTask
extends KoalaTask
implements MotionSource {
    @req(value="camera")
    public KoalaCamera camera;
    private volatile KoalaVector direction = new KoalaVector(0.0, 0.0);

    public VisualFollowingTask() {
    }

    public VisualFollowingTask(Koala koala) {
        super(koala);
        this.camera = new Webcam();
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
        this.camera = new Webcam();
    }

    public void run() {
        int[] nArray = new int[]{70, 255, -1, 10, -1, 70};
        try {
            while (this.running) {
                KoalaImage koalaImage = new KoalaImage(this.camera.getImage(), 640, 480);
                koalaImage.applyRedThreshold(140, 1.2, 1.2);
                KoalaImage.Blob blob = koalaImage.getLargestBlob(Color.red, 250);
                if (blob == null) {
                    System.out.println("not found.");
                    this.direction = new KoalaVector(0.0, 0.0);
                } else {
                    int n = 320 - blob.x;
                    int n2 = 240 - blob.y;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    int n3 = 10000 / blob.size;
                    System.out.println("Blob size " + blob.size);
                    int n4 = n / 16;
                    if (n4 < 0) {
                        n4 += 360;
                    }
                    System.out.println("Dir: " + n4);
                    System.out.println("Mag: " + n3);
                    this.direction = KoalaVector.createFromMagAndDir(n3, n4);
                }
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException interruptedException) {
            this.running = false;
        }
    }

    public void halt() {
        this.direction = new KoalaVector(0.0, 0.0);
        this.running = false;
    }

    public KoalaVector getDirection() {
        return this.direction;
    }
}

