/*
 * Decompiled with CFR 0.152.
 */
package koala.remote;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.Vector;
import koala.KoalaLocation;
import koala.remote.LocationServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkyCamera
implements LocationServer,
TranquilComponent {
    private LocationServer locator;
    private final transient String locatorName = System.getProperty("centralControl") == null ? "madeira" : System.getProperty("centralControl");
    private DynamicBackbone.RemoteDynamicBackbone failureHandler;
    private KoalaLocation lastRedLocation = null;
    private KoalaLocation lastGreenLocation = null;
    private long timeOfLastRequest = 0L;

    public SkyCamera() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.locator = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("SkyCamera: Cannot connect to infrastructure (central control: " + this.locatorName + ")");
        }
    }

    @Override
    public synchronized KoalaLocation getRobotLocation(boolean bl) throws RemoteException {
        long l = System.currentTimeMillis();
        if (l - this.timeOfLastRequest > 250L || bl && this.lastRedLocation == null || !bl && this.lastGreenLocation == null) {
            KoalaLocation koalaLocation = this.locator.getRobotLocation(bl);
            for (int i = 0; koalaLocation == null && i < 4; ++i) {
                koalaLocation = this.locator.getRobotLocation(bl);
            }
            if (bl) {
                this.lastRedLocation = koalaLocation;
            } else {
                this.lastGreenLocation = koalaLocation;
            }
            this.timeOfLastRequest = l;
            return koalaLocation;
        }
        System.out.println("SkyCamera: Using cached value");
        if (bl) {
            return this.lastRedLocation;
        }
        return this.lastGreenLocation;
    }

    @Override
    public boolean canSee(KoalaLocation koalaLocation) throws RemoteException {
        return this.locator.canSee(koalaLocation);
    }

    @Override
    public KoalaLocation getTopLeft() throws RemoteException {
        return this.locator.getTopLeft();
    }

    @Override
    public KoalaLocation getTopRight() throws RemoteException {
        return this.locator.getTopRight();
    }

    @Override
    public KoalaLocation getBottomLeft() throws RemoteException {
        return this.locator.getBottomLeft();
    }

    @Override
    public KoalaLocation getBottomRight() throws RemoteException {
        return this.locator.getBottomRight();
    }

    @Override
    public boolean isNear(KoalaLocation koalaLocation, String string) throws RemoteException {
        return this.locator.isNear(koalaLocation, string);
    }

    @Override
    public boolean robotInLocation(String string, String string2) throws RemoteException {
        return this.locator.robotInLocation(string, string2);
    }

    @Override
    public KoalaLocation getLocation(String string) throws RemoteException {
        return this.locator.getLocation(string);
    }

    public void startComponent() {
    }

    public void stopComponent() {
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
        this.failureHandler = remoteDynamicBackbone;
    }
}

