/*
 * Decompiled with CFR 0.152.
 */
package koala.remote;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import koala.KoalaCamera;
import koala.KoalaImage;

public class Webcam
implements KoalaCamera {
    private final int threshold = 60;
    private final int sizeThreshold = 200;
    private FrameGrabbingControl frameGrabber;
    private Dimension videoSize;
    private Frame window;
    private GUIThread windowThread;
    private Color lastColour = Color.red;

    public Webcam() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("java.rmi.server.hostname");
        CaptureDeviceInfo captureDeviceInfo = null;
        if (string.contains("Windows")) {
            captureDeviceInfo = CaptureDeviceManager.getDevice((String)"vfw:Microsoft WDM Image Capture (Win32):0");
        } else if (string2 != null && string2.equals("das05eee")) {
            captureDeviceInfo = CaptureDeviceManager.getDevice((String)"v4l:UVC Camera (eb1a:2761):0");
        } else {
            System.err.println("Webcam: PLATFORM " + string + " NOT SUPPORTED.");
            System.exit(-1);
        }
        if (captureDeviceInfo == null) {
            System.err.println("Webcam: Unable to connect to capture device.");
            System.exit(-1);
        }
        try {
            Player player = Manager.createRealizedPlayer((MediaLocator)captureDeviceInfo.getLocator());
            FormatControl formatControl = (FormatControl)player.getControl("javax.media.control.FormatControl");
            this.videoSize = null;
            VideoFormat videoFormat = null;
            for (Format format : formatControl.getSupportedFormats()) {
                VideoFormat videoFormat2 = (VideoFormat)format;
                Dimension dimension = videoFormat2.getSize();
                if (videoFormat2.getEncoding().equals("rgb") && dimension.width >= 640) {
                    videoFormat = videoFormat2;
                    this.videoSize = dimension;
                    continue;
                }
                if (videoFormat != null || dimension.width < 320) continue;
                videoFormat = videoFormat2;
                this.videoSize = dimension;
            }
            if (videoFormat == null) {
                System.err.println("Webcam: No useful video format found.");
                System.exit(-1);
            }
            formatControl.setFormat(videoFormat);
            formatControl.setEnabled(true);
            this.frameGrabber = (FrameGrabbingControl)player.getControl("javax.media.control.FrameGrabbingControl");
            player.start();
            this.window = new Frame("Webcam");
            this.window.setBounds(0, 0, this.videoSize.width + 20, this.videoSize.height + 40);
            this.window.setResizable(false);
            this.window.setVisible(true);
            this.windowThread = new GUIThread();
            this.windowThread.start();
        }
        catch (Exception exception) {
            System.err.println("Webcam image capture problem: ");
            exception.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.windowThread.halt();
    }

    public int[] getImage() {
        if (!System.getProperty("os.name").contains("Windows")) {
            System.err.println("Webcam class currently requires Video For Windows, and must be run under Windows.");
            return null;
        }
        Buffer buffer = this.frameGrabber.grabFrame();
        BufferToImage bufferToImage = new BufferToImage((VideoFormat)buffer.getFormat());
        Image image = bufferToImage.createImage(buffer);
        BufferedImage bufferedImage = new BufferedImage(this.videoSize.width, this.videoSize.height, 1);
        bufferedImage.createGraphics().drawImage(image, null, null);
        int[] nArray = new int[this.videoSize.width * this.videoSize.height];
        return bufferedImage.getRGB(0, 0, this.videoSize.width, this.videoSize.height, nArray, 0, this.videoSize.width);
    }

    public Point getSpotPosition(Color color) {
        int[] nArray = new int[]{color.getRed() - 60, color.getRed() + 60, color.getGreen() - 60, color.getGreen() + 60, color.getBlue() - 60, color.getBlue() + 60};
        return this.getSpotPosition(color, nArray);
    }

    public Point getSpotPosition(Color color, int[] nArray) {
        this.lastColour = color;
        Buffer buffer = this.frameGrabber.grabFrame();
        BufferToImage bufferToImage = new BufferToImage((VideoFormat)buffer.getFormat());
        Image image = bufferToImage.createImage(buffer);
        if (image == null) {
            System.out.println("No image... camera not ready?");
            return null;
        }
        KoalaImage koalaImage = new KoalaImage(image);
        koalaImage.applyThreshold(color, nArray);
        return koalaImage.getLargestBlob(color, 200);
    }

    private class GUIThread
    extends Thread {
        public volatile boolean running;

        private GUIThread() {
        }

        public void run() {
            try {
                this.running = true;
                while (this.running) {
                    int[] nArray = Webcam.this.getImage();
                    BufferedImage bufferedImage = new BufferedImage(((Webcam)Webcam.this).videoSize.width, ((Webcam)Webcam.this).videoSize.height, 1);
                    bufferedImage.setRGB(0, 0, ((Webcam)Webcam.this).videoSize.width, ((Webcam)Webcam.this).videoSize.height, nArray, 0, ((Webcam)Webcam.this).videoSize.width);
                    Graphics graphics = Webcam.this.window.getGraphics();
                    graphics.drawImage(bufferedImage, 10, 30, ((Webcam)Webcam.this).videoSize.width, ((Webcam)Webcam.this).videoSize.height, null);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void halt() {
            this.running = false;
        }
    }
}

