/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import koala.Koala;
import koala.KoalaLocation;
import koala.KoalaMotorController;
import koala.KoalaVector;
import koala.motion.MotionSource;
import koala.motion.ObstacleAvoider;
import koala.motion.VectorMotionController;
import koala.remote.BallLocationServer;
import koala.task.KoalaTask;

public class BallFetchTask
extends KoalaTask
implements MotionSource {
    private VectorMotionController motionController;
    private KoalaLocation target;
    private volatile KoalaVector direction = new KoalaVector(0.0, 0.0);
    private BallLocationServer locator;
    private boolean iAmRed;

    public BallFetchTask() {
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
    }

    public BallFetchTask(KoalaLocation koalaLocation) {
        this.target = koalaLocation;
        Koala koala = Koala.getInstance();
        this.motionController = new VectorMotionController();
        this.motionController.motors = new KoalaMotorController(koala);
        ObstacleAvoider obstacleAvoider = new ObstacleAvoider();
        obstacleAvoider.sensors = koala;
        this.motionController.registerMotionSource(obstacleAvoider, 5);
        this.motionController.registerMotionSource(this, 1);
        this.motionController.startComponent();
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.locator = (BallLocationServer)Naming.lookup("rmi://pajaro/location");
            this.iAmRed = System.getProperty("robotColour").equals("red");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean close(int n, int n2) {
        return Math.abs(n - n2) < 200;
    }

    private boolean near(KoalaLocation koalaLocation, KoalaLocation koalaLocation2) {
        return this.close(koalaLocation.x, koalaLocation2.x) && this.close(koalaLocation.y, koalaLocation2.y);
    }

    public void run() {
        try {
            boolean bl = false;
            KoalaLocation koalaLocation = this.locator.getBallLocation();
            KoalaVector koalaVector = koalaLocation.getVectorTo(this.target);
            koalaVector.normalise();
            koalaVector.scale(-1000.0);
            KoalaLocation koalaLocation2 = new KoalaLocation((int)Math.round((double)koalaLocation.x + koalaVector.x), (int)Math.round((double)koalaLocation.y + koalaVector.y));
            while (this.running) {
                int n;
                KoalaLocation koalaLocation3 = this.locator.getRobotLocation(this.iAmRed);
                if (koalaLocation3 == null) {
                    System.err.println("LOST MYSELF");
                    System.exit(-1);
                }
                if (bl && this.near(this.target, koalaLocation3)) {
                    System.out.println("ARRIVED");
                    this.motionController.stopComponent();
                    this.motionController.motors.setSpeed(0, 0);
                    System.exit(0);
                } else if (bl || this.near(koalaLocation2, koalaLocation3)) {
                    n = koalaLocation3.getRotationTo(this.target);
                    if (!bl) {
                        bl = true;
                        this.direction = new KoalaVector(0.0, 0.0);
                        System.out.println("TURNING TOWARDS TARGET");
                        this.motionController.motors.rotate(n);
                    }
                    if (n != 999) {
                        System.out.println("target:relhead " + n);
                        this.direction = KoalaVector.createFromMagAndDir(1.0, n);
                    }
                } else {
                    n = koalaLocation3.getRotationTo(koalaLocation2);
                    if (n != 999) {
                        System.out.println("ball:relhead " + n);
                        this.direction = KoalaVector.createFromMagAndDir(1.0, n);
                    }
                }
                Thread.sleep(500L);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Sleep interrupted.");
        }
    }

    public KoalaVector getDirection() {
        return this.direction;
    }

    public static void main(String[] stringArray) {
        new BallFetchTask(new KoalaLocation(50, 2430)).start();
    }
}

