/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import com.hopstepjump.backbone.api.req;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import koala.Koala;
import koala.KoalaCamera;
import koala.KoalaLocation;
import koala.remote.LocationServer;
import koala.task.AchievedGoalEvent;
import koala.task.FailedEvent;
import koala.task.GoToTask;
import koala.task.KoalaTask;
import koala.task.KoalaTaskEvent;
import koala.task.KoalaTaskListener;
import koala.task.NetworkFailedEvent;
import koala.task.PhotoTakenEvent;

public class FollowReconTask
extends KoalaTask {
    @req(value="camera")
    public transient KoalaCamera camera;
    private transient GoToTask goTo = null;
    private final transient String locatorName = System.getProperty("centralControl") == null ? "madeira" : System.getProperty("centralControl");

    public FollowReconTask(Koala koala) {
        super(koala);
    }

    public FollowReconTask() {
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
        System.out.println("inited");
        if (objectArray.length == 1) {
            System.out.println("Taking photo");
            int[] nArray = this.camera.getImage();
            this.goTo = null;
            this.camera = null;
            this.eventHappened(new PhotoTakenEvent(this, nArray));
        }
    }

    private boolean near(int n, int n2) {
        return Math.abs(n - n2) < 1000;
    }

    public void run() {
        System.out.println("frt:run()");
        LocationServer locationServer = null;
        boolean bl = false;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            locationServer = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
        }
        catch (RemoteException remoteException) {
            this.eventHappened(new NetworkFailedEvent(this, this.locatorName, remoteException.getClass().getName()));
            this.halt();
        }
        catch (NotBoundException notBoundException) {
            this.eventHappened(new NetworkFailedEvent(this, this.locatorName, notBoundException.getClass().getName()));
            this.halt();
        }
        catch (Exception exception) {
            this.halt();
            exception.printStackTrace();
        }
        bl = System.getProperty("robotColour").equals("red");
        try {
            while (this.running) {
                KoalaLocation koalaLocation = locationServer.getRobotLocation(!bl);
                KoalaLocation koalaLocation2 = locationServer.getRobotLocation(bl);
                if (koalaLocation == null || koalaLocation2 == null) {
                    this.eventHappened(new FailedEvent(this));
                    this.halt();
                    continue;
                }
                if (this.near(koalaLocation.x, koalaLocation2.x) && this.near(koalaLocation.y, koalaLocation2.y)) {
                    System.out.println("Stopping, briefly");
                    if (this.goTo == null) continue;
                    this.goTo.halt();
                    this.goTo = null;
                    continue;
                }
                if (this.goTo != null) {
                    this.goTo.updateTarget(koalaLocation);
                } else {
                    this.goTo = new GoToTask(koalaLocation.x, koalaLocation.y);
                    this.goTo.setRobot(this.motors, this.sensors, this.longRangeSensors);
                    this.goTo.addListener(new GoToListener());
                    this.goTo.setAvoidRobot(false);
                    this.goTo.start();
                }
                System.out.println("Going somewhere...");
                Thread.sleep(700L);
            }
        }
        catch (RemoteException remoteException) {
            this.eventHappened(new NetworkFailedEvent(this, this.locatorName, remoteException.getClass().getName()));
            this.halt();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Sleep interrupted");
            this.halt();
        }
    }

    public void halt() {
        System.out.println("Haltestelle");
        if (this.goTo != null) {
            this.goTo.halt();
        }
        super.halt();
    }

    private void propagateEvent(KoalaTaskEvent koalaTaskEvent) {
        this.goTo = null;
        this.camera = null;
        this.eventHappened(koalaTaskEvent);
    }

    private class GoToListener
    implements KoalaTaskListener,
    Serializable {
        private GoToListener() {
        }

        public void eventHappened(KoalaTaskEvent koalaTaskEvent) {
            System.out.println("GoTo event: " + koalaTaskEvent);
            if (koalaTaskEvent instanceof FailedEvent) {
                FollowReconTask.this.halt();
            } else if (koalaTaskEvent instanceof AchievedGoalEvent) {
                FollowReconTask.this.halt();
            }
        }
    }
}

