/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import koala.Koala;
import koala.KoalaSensorReading;
import koala.task.KoalaTask;

public class FollowingTask
extends KoalaTask {
    public FollowingTask() {
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
    }

    public FollowingTask(Koala koala) {
        super(koala);
    }

    private int toSpeed(double d) {
        if (d <= 400.0) {
            return (int)Math.round(-0.075 * d + 30.0);
        }
        return (int)Math.round(-0.05 * (d - 400.0));
    }

    public void run() {
        try {
            while (this.running) {
                int n;
                KoalaSensorReading koalaSensorReading = this.sensors.readProximitySensors();
                double d = 0.0;
                for (int i = 0; i < 4; ++i) {
                    if (!((double)koalaSensorReading.leftSensors[i] > d)) continue;
                    d = koalaSensorReading.leftSensors[i];
                }
                double d2 = 0.0;
                for (n = 0; n < 4; ++n) {
                    if (!((double)koalaSensorReading.rightSensors[n] > d2)) continue;
                    d2 = koalaSensorReading.rightSensors[n];
                }
                n = this.toSpeed(d);
                int n2 = this.toSpeed(d2);
                if (n > 30) {
                    System.out.println("Limiting left speed");
                    n = 30;
                }
                if (n2 > 30) {
                    System.out.println("Limiting right speed");
                    n2 = 30;
                }
                if (n == 0 && n2 == 0) {
                    this.sensors.turnLEDOn(0);
                } else {
                    this.sensors.turnLEDOff(0);
                }
                this.motors.setSpeed(n, n2);
                Thread.sleep(100L);
            }
            this.motors.setSpeed(0, 0);
            this.sensors.turnLEDOff(0);
        }
        catch (InterruptedException interruptedException) {
            this.running = false;
        }
    }
}

