/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import koala.KoalaLocation;
import koala.KoalaLongRangeSensors;
import koala.KoalaMotorController;
import koala.KoalaMotors;
import koala.KoalaSensorReading;
import koala.KoalaSensors;
import koala.KoalaVector;
import koala.remote.LocationServer;
import koala.task.AchievedGoalEvent;
import koala.task.FailedEvent;
import koala.task.KoalaTask;
import koala.task.NetworkFailedEvent;
import koala.task.TargetOutOfRangeEvent;
import koala.task.UnknownHeadingEvent;

public class GoToTask
extends KoalaTask {
    private volatile KoalaLocation target;
    private String targetName;
    private transient LocationServer locator;
    private boolean iAmRed;
    private String robotName;
    private final transient String locatorName = System.getProperty("centralControl") == null ? "madeira" : System.getProperty("centralControl");
    private static final int obstacleThreshold = 150;
    private static final int robotThreshold = 550;
    private int threshold;
    private boolean avoidRobot = true;

    public GoToTask() {
        this.threshold = 150;
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.locator = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
            this.iAmRed = System.getProperty("robotColour").equals("red");
            this.robotName = System.getProperty("java.rmi.server.hostname");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (objectArray.length == 2 && objectArray[0] instanceof Integer && objectArray[1] instanceof Integer) {
            this.target = new KoalaLocation((Integer)objectArray[0], (Integer)objectArray[1]);
        } else if (objectArray.length == 1 && objectArray[0] instanceof String) {
            this.targetName = this.targetName = (String)objectArray[0];
            try {
                this.target = this.locator.getLocation(this.targetName);
            }
            catch (RemoteException remoteException) {
                System.err.println("GoToTask exception: " + remoteException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Argument list must match (Integer x, Integer y) or (String targetName).");
        }
    }

    public GoToTask(int n, int n2) {
        this(n, n2, 40);
    }

    public GoToTask(int n, int n2, int n3) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.locator = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
            this.iAmRed = System.getProperty("robotColour").equals("red");
            this.robotName = System.getProperty("java.rmi.server.hostname");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.target = new KoalaLocation(n, n2);
        this.threshold = n3;
    }

    public GoToTask(String string) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            this.locator = (LocationServer)Naming.lookup("rmi://" + this.locatorName + "/location");
            this.iAmRed = System.getProperty("robotColour").equals("red");
            this.robotName = System.getProperty("java.rmi.server.hostname");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.targetName = string;
        try {
            this.target = this.locator.getLocation(string);
        }
        catch (RemoteException remoteException) {
            System.err.println("GoToTask exception: " + remoteException.getMessage());
        }
    }

    public void updateTarget(KoalaLocation koalaLocation) {
        if (koalaLocation != null) {
            this.target = koalaLocation;
        }
    }

    public void setAvoidRobot(boolean bl) {
        this.avoidRobot = bl;
    }

    public void setRobot(KoalaMotors koalaMotors, KoalaSensors koalaSensors, KoalaLongRangeSensors koalaLongRangeSensors) {
        super.setRobot(new KoalaMotorController(koalaMotors), koalaSensors, koalaLongRangeSensors);
    }

    private KoalaVector obstacleVector(KoalaLocation koalaLocation, KoalaSensorReading koalaSensorReading, double d, int n) throws RemoteException {
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 180 - n;
        for (n2 = 0; n2 < 3; ++n2) {
            if (koalaSensorReading.leftSensors[n2] > 150) {
                d2 += (double)koalaSensorReading.leftSensors[n2] * Math.cos(Math.toRadians(n3));
                d3 += (double)koalaSensorReading.leftSensors[n2] * Math.sin(Math.toRadians(n3));
            }
            if (koalaSensorReading.rightSensors[n2] <= 150) continue;
            d2 += (double)koalaSensorReading.rightSensors[n2] * Math.cos(Math.toRadians(n3));
            d3 += (double)koalaSensorReading.rightSensors[n2] * Math.sin(Math.toRadians(n3));
        }
        if (koalaSensorReading.leftSensors[3] > 150) {
            d2 += (double)(2 * koalaSensorReading.leftSensors[3]) * Math.cos(Math.toRadians(n3 - 45));
            d3 += (double)(2 * koalaSensorReading.leftSensors[3]) * Math.sin(Math.toRadians(n3 - 45));
        }
        if (koalaSensorReading.rightSensors[3] > 150) {
            d2 += (double)(2 * koalaSensorReading.rightSensors[3]) * Math.cos(Math.toRadians(n3 + 45));
            d3 += (double)(2 * koalaSensorReading.rightSensors[3]) * Math.sin(Math.toRadians(n3 + 45));
        }
        for (n2 = 4; n2 < 6; ++n2) {
            if (koalaSensorReading.leftSensors[n2] > 150) {
                d2 += Math.cos(Math.toRadians(n3 - 90));
                d3 += Math.sin(Math.toRadians(n3 - 90));
            }
            if (koalaSensorReading.rightSensors[n2] <= 150) continue;
            d2 += Math.cos(Math.toRadians(n3 + 90));
            d3 += Math.sin(Math.toRadians(n3 + 90));
        }
        KoalaVector koalaVector = new KoalaVector(d2, d3);
        System.out.println("Obs vector dir " + koalaVector.direction());
        koalaVector.normalise();
        koalaVector.scale(4.0 * d);
        return koalaVector;
    }

    protected boolean succeeded(KoalaLocation koalaLocation) {
        if (this.targetName != null) {
            try {
                return this.locator.robotInLocation(this.robotName, this.targetName);
            }
            catch (RemoteException remoteException) {
                System.err.println("GoToTask exception: " + remoteException.getMessage());
            }
        }
        return Math.abs(koalaLocation.x - this.target.x) < this.threshold && Math.abs(koalaLocation.y - this.target.y) < this.threshold;
    }

    public void run() {
        KoalaLocation koalaLocation = null;
        KoalaLocation koalaLocation2 = null;
        System.out.println("Going to " + this.target.x + ", " + this.target.y);
        try {
            if (!this.locator.canSee(new KoalaLocation(this.target.x, this.target.y))) {
                this.halt();
                this.eventHappened(new TargetOutOfRangeEvent(this));
            }
        }
        catch (RemoteException remoteException) {
            System.err.println("GoToTask exception: " + remoteException.getMessage());
        }
        try {
            koalaLocation = this.locator.getRobotLocation(this.iAmRed);
        }
        catch (RemoteException remoteException) {
            System.err.println("GoToTask exception: " + remoteException.getMessage());
        }
        while (this.running) {
            try {
                if (koalaLocation == null) {
                    this.halt();
                    this.eventHappened(new FailedEvent(this));
                    continue;
                }
                if (koalaLocation2 != null && koalaLocation.heading == 999) {
                    System.out.println("Fudging heading");
                    koalaLocation.heading = koalaLocation2.heading;
                }
                if (this.succeeded(koalaLocation)) {
                    this.halt();
                    this.eventHappened(new AchievedGoalEvent(this));
                    continue;
                }
                if (koalaLocation.heading == 999) {
                    this.halt();
                    this.eventHappened(new UnknownHeadingEvent(this));
                    continue;
                }
                KoalaVector koalaVector = koalaLocation.getVectorTo(this.target);
                System.out.println("Heading dir " + koalaVector.direction());
                KoalaSensorReading koalaSensorReading = this.sensors.readProximitySensors();
                double d = koalaVector.magnitude();
                KoalaVector koalaVector2 = this.obstacleVector(koalaLocation, koalaSensorReading, d, koalaLocation.heading);
                koalaVector = koalaVector.add(koalaVector2);
                koalaVector = koalaVector2;
                int n = koalaVector.direction();
                System.out.println("-> targetheading " + n);
                int n2 = n - koalaLocation.heading;
                if (n2 > 180) {
                    n2 -= 360;
                } else if (n2 < -180) {
                    n2 += 360;
                }
                System.out.println("current heading " + koalaLocation.heading + "; rotate by " + n2);
                koalaLocation2 = koalaLocation;
                if (d < 80.0) {
                    if (Math.abs(n2) > 1) {
                        this.motors.rotate(n2);
                    }
                    this.halt();
                    this.eventHappened(new AchievedGoalEvent(this));
                } else if (n2 > 0) {
                    this.motors.setSpeed(30 - n2 * 1 * 30 / 120, 30);
                } else {
                    this.motors.setSpeed(30, 30 + n2 * 1 * 30 / 120);
                }
                Thread.sleep(250L);
                koalaLocation = this.locator.getRobotLocation(this.iAmRed);
            }
            catch (RemoteException remoteException) {
                this.halt();
                this.eventHappened(new NetworkFailedEvent(this, this.locatorName, remoteException.getClass().getName()));
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Sleep interrupted");
                this.halt();
            }
        }
        this.motors.setSpeed(0, 0);
    }

    public void halt() {
        this.running = false;
        this.motors.setSpeed(0, 0);
    }
}

