/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import koala.Koala;
import koala.KoalaSensorReading;
import koala.task.AvoidanceTask;
import koala.task.KoalaTask;
import koala.task.WallFollowingTask;

public class WallFollowAvoidTask
extends KoalaTask {
    private AvoidanceTask avoid;
    private WallFollowingTask wall;

    public WallFollowAvoidTask() {
    }

    public WallFollowAvoidTask(Koala koala) {
        super(koala);
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
    }

    public void setRobot(Koala koala) {
        this.wall = new WallFollowingTask(koala);
        this.avoid = new AvoidanceTask(koala);
    }

    public void run() {
        boolean bl = false;
        try {
            this.wall.start();
            System.out.println("WFATask: Following wall");
            while (this.running) {
                if (!bl) {
                    KoalaSensorReading koalaSensorReading = this.sensors.readProximitySensors();
                    int n = 0;
                    for (int i = 0; i < 8; ++i) {
                        n += koalaSensorReading.leftSensors[i] + koalaSensorReading.rightSensors[i];
                    }
                    if (n < 320) {
                        this.wall.halt();
                        System.out.println("WFATask: Lost wall, switching to avoidance");
                        Thread.sleep(1000L);
                        bl = true;
                        this.avoid.start();
                    }
                }
                Thread.sleep(500L);
            }
            System.out.println("WFATask: Halting");
            this.avoid.halt();
            this.wall.halt();
        }
        catch (InterruptedException interruptedException) {
            this.running = false;
        }
    }
}

