/*
 * Decompiled with CFR 0.152.
 */
package koala.virtual;

import com.cyberbotics.webots.Controller;
import java.awt.Polygon;
import java.rmi.RemoteException;
import koala.KoalaLocation;
import koala.remote.LocationServer;
import koala.virtual.DomainManager;

public class VirtualSkyCamera
extends Controller
implements LocationServer {
    public static int gps;
    DomainManager dm;
    private static String ROBOT_FILE;
    private static String LOC_FILE;
    private Polygon visibleSpace;
    KoalaLocation tl;
    KoalaLocation tr;
    KoalaLocation bl;
    KoalaLocation br;

    public VirtualSkyCamera() {
        gps = VirtualSkyCamera.robot_get_device((String)"gps");
        try {
            this.dm = new DomainManager(ROBOT_FILE, LOC_FILE);
            this.tl = this.getTopLeft();
            this.tr = this.getTopRight();
            this.bl = this.getBottomLeft();
            this.br = this.getBottomRight();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.visibleSpace = new Polygon();
        this.visibleSpace.addPoint(this.tl.x, this.tl.y);
        this.visibleSpace.addPoint(this.tr.x, this.tr.y);
        this.visibleSpace.addPoint(this.br.x, this.br.y);
        this.visibleSpace.addPoint(this.bl.x, this.bl.y);
    }

    public KoalaLocation getRobotLocation(boolean bl) throws RemoteException {
        float[] fArray = VirtualSkyCamera.gps_get_matrix((int)gps);
        float[] fArray2 = VirtualSkyCamera.gps_euler((float[])fArray);
        int n = (int)Math.toDegrees(fArray2[1]);
        n = (n + 180) % 360;
        int n2 = (int)(1000.0f * VirtualSkyCamera.gps_position_z((float[])fArray));
        int n3 = (int)(1000.0f * VirtualSkyCamera.gps_position_x((float[])fArray));
        return new KoalaLocation(n2, n3, n);
    }

    public boolean canSee(KoalaLocation koalaLocation) throws RemoteException {
        return this.visibleSpace.contains(koalaLocation.x, koalaLocation.y);
    }

    public KoalaLocation getTopLeft() throws RemoteException {
        return this.getLocation("topLeft");
    }

    public KoalaLocation getTopRight() throws RemoteException {
        return this.getLocation("topRight");
    }

    public KoalaLocation getBottomLeft() throws RemoteException {
        return this.getLocation("bottomLeft");
    }

    public KoalaLocation getBottomRight() throws RemoteException {
        return this.getLocation("bottomRight");
    }

    public boolean isNear(KoalaLocation koalaLocation, String string) throws RemoteException {
        return this.dm.isNear(koalaLocation, string);
    }

    public boolean robotInLocation(String string, String string2) throws RemoteException {
        KoalaLocation koalaLocation = this.getRobotLocation(true);
        return this.isNear(koalaLocation, string2);
    }

    public KoalaLocation getLocation(String string) throws RemoteException {
        return this.dm.getLocation(string);
    }

    public DomainManager getDomainManager() throws RemoteException {
        return this.dm;
    }

    static {
        ROBOT_FILE = "robots.txt";
        LOC_FILE = "locations.txt";
    }
}

