/*
 * Decompiled with CFR 0.152.
 */
package koala;

import java.io.Serializable;

public class KoalaVector
implements Serializable {
    public double x;
    public double y;

    public KoalaVector(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public static KoalaVector createFromMagAndDir(double d, double d2) {
        return new KoalaVector(d * Math.cos(Math.toRadians(d2)), d * Math.sin(Math.toRadians(d2)));
    }

    public int direction() {
        int n = (int)Math.round(Math.toDegrees(Math.atan(this.y / this.x)));
        if (this.x < 0.0) {
            n = 180 + n;
        }
        if (this.y < 0.0) {
            n = 360 + n;
        }
        return this.properModulo(n, 360);
    }

    private int properModulo(int n, int n2) {
        if (n < 0) {
            n *= -1;
        }
        return n % n2;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public KoalaVector add(KoalaVector koalaVector) {
        return new KoalaVector(this.x + koalaVector.x, this.y + koalaVector.y);
    }

    public KoalaVector subtract(KoalaVector koalaVector) {
        return new KoalaVector(this.x - koalaVector.x, this.y - koalaVector.y);
    }

    public void normalise() {
        double d = this.magnitude();
        if (d != 0.0) {
            this.x /= d;
            this.y /= d;
        }
    }

    public void scale(double d) {
        this.x *= d;
        this.y *= d;
    }

    public int integerX() {
        return (int)Math.round(this.x);
    }

    public int integerY() {
        return (int)Math.round(this.y);
    }

    public boolean equals(Object object) {
        if (object instanceof KoalaVector) {
            KoalaVector koalaVector = (KoalaVector)object;
            return koalaVector.x == this.x && koalaVector.y == this.y;
        }
        return false;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public static void main(String[] stringArray) {
        KoalaVector koalaVector = new KoalaVector(3.0, 4.0);
        System.out.println(koalaVector);
        int n = koalaVector.direction();
        double d = koalaVector.magnitude();
        System.out.println("dir " + n);
        KoalaVector koalaVector2 = KoalaVector.createFromMagAndDir(d, n);
        System.out.println(koalaVector2);
        KoalaVector koalaVector3 = new KoalaVector(-3.0, 4.0);
        System.out.println(koalaVector3);
        n = koalaVector3.direction();
        d = koalaVector3.magnitude();
        System.out.println("dir " + n);
        KoalaVector koalaVector4 = KoalaVector.createFromMagAndDir(d, n);
        System.out.println(koalaVector4);
        KoalaVector koalaVector5 = new KoalaVector(3.0, -4.0);
        System.out.println(koalaVector5);
        n = koalaVector5.direction();
        d = koalaVector5.magnitude();
        System.out.println("dir " + n);
        KoalaVector koalaVector6 = KoalaVector.createFromMagAndDir(d, n);
        System.out.println(koalaVector6);
        KoalaVector koalaVector7 = new KoalaVector(-3.0, -4.0);
        System.out.println(koalaVector7);
        n = koalaVector7.direction();
        d = koalaVector7.magnitude();
        System.out.println("dir " + n);
        KoalaVector koalaVector8 = KoalaVector.createFromMagAndDir(d, n);
        System.out.println(koalaVector8);
    }
}

