/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import koala.KoalaVector;
import koala.motion.MotionController;
import koala.motion.MotionSource;
import koala.motion.SearchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomSearchPattern
implements MotionSource,
SearchPattern,
TranquilComponent {
    @req(value="controller")
    public transient MotionController controller;
    private volatile transient KoalaVector direction = new KoalaVector(0.0, 0.0);
    private ZThread zThread;

    public void startComponent() {
        System.out.println("RandomSearchPattern: Registering with motion controller.");
        this.controller.registerMotionSource(this, 5);
        try {
            this.startSearch();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void stopComponent() {
        try {
            this.stopSearch();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
    }

    @Override
    public void startSearch() throws RemoteException {
        if (this.zThread != null) {
            this.stopSearch();
        }
        System.out.println("RANDOM POWER NOW");
        if (this.zThread != null) {
            this.zThread.halt();
        }
        this.zThread = new ZThread();
        this.zThread.start();
    }

    @Override
    public void stopSearch() throws RemoteException {
        System.out.println("RANDOM MUST STOP");
        this.zThread.halt();
        this.direction = new KoalaVector(0.0, 0.0);
        System.out.println("RANDOM HAS STOPPED");
    }

    @Override
    public KoalaVector getDirection() {
        return this.direction;
    }

    public class ZThread
    extends Thread {
        private volatile boolean running = true;

        public void run() {
            int n = 0;
            int n2 = 0;
            while (this.running) {
                if (n2 == 0) {
                    n = (int)Math.round(Math.random() * 360.0);
                } else if ((n -= 30) < 0) {
                    n = 0;
                }
                System.out.println("RandomSearchPattern: Heading = " + n);
                RandomSearchPattern.this.direction = KoalaVector.createFromMagAndDir(2.0, n);
                n2 = (n2 + 1) % 20;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void halt() {
            this.running = false;
        }
    }

    public class RemoteProxy
    extends UnicastRemoteObject
    implements SearchPattern {
        public void startSearch() throws RemoteException {
            RandomSearchPattern.this.startSearch();
        }

        public void stopSearch() throws RemoteException {
            RandomSearchPattern.this.stopSearch();
        }
    }
}

