/*
 * Decompiled with CFR 0.152.
 */
package koala.motion;

import com.hopstepjump.backbone.DynamicBackbone;
import com.hopstepjump.backbone.api.TranquilComponent;
import com.hopstepjump.backbone.api.req;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import koala.KoalaLocation;
import koala.KoalaMotors;
import koala.KoalaVector;
import koala.motion.MotionController;
import koala.motion.MotionSource;
import koala.motion.SearchPattern;
import koala.remote.LocationServer;
import koala.task.FailedEvent;
import koala.task.KoalaTaskEvent;
import koala.task.NetworkFailedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZigZagSearchPattern
implements MotionSource,
SearchPattern,
TranquilComponent {
    @req(value="controller")
    public transient MotionController controller;
    @req(value="motors")
    public transient KoalaMotors motors;
    @req(value="locator")
    public transient LocationServer locator;
    private boolean iAmRed;
    private String robotName;
    private volatile transient KoalaVector direction = new KoalaVector(0.0, 0.0);
    private ZThread zThread;
    private DynamicBackbone.RemoteDynamicBackbone failureHandler;
    private final int timeOut = 15000;
    private final int robotSize = 200;
    private final int xStep = 400;
    private int spaceWidth;
    private int spaceHeight;
    private KoalaLocation searchRoot;
    private KoalaLocation currentWaypoint;
    private boolean movingLeft;

    public ZigZagSearchPattern() {
        try {
            this.iAmRed = System.getProperty("robotColour").equals("red");
            this.robotName = System.getProperty("java.rmi.server.hostname");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startComponent() {
        System.out.println("ZigZagSearchPattern: Registering with motion controller.");
        this.controller.registerMotionSource(this, 5);
        try {
            this.startSearch();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void stopComponent() {
        this.controller.deregisterMotionSource(this);
        try {
            this.stopSearch();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Vector<Object> getReusedComponents() {
        return null;
    }

    public void setFailureHandler(DynamicBackbone.RemoteDynamicBackbone remoteDynamicBackbone) {
        this.failureHandler = remoteDynamicBackbone;
    }

    public KoalaLocation nearestWaypoint(KoalaLocation koalaLocation) {
        int n = koalaLocation.x / 400 * 400;
        int n2 = koalaLocation.y / 200 * 200;
        return new KoalaLocation(n, n2);
    }

    public KoalaLocation nextWaypoint(KoalaLocation koalaLocation) {
        int n = this.movingLeft ? koalaLocation.x + 400 : koalaLocation.x - 400;
        int n2 = koalaLocation.y;
        if (n >= this.searchRoot.x + this.spaceWidth || n <= this.searchRoot.x) {
            System.out.println("TURNING");
            this.motors.rotate(180.0);
            this.movingLeft = !this.movingLeft;
            n = this.movingLeft ? koalaLocation.x + 400 : koalaLocation.x - 400;
            if ((n2 += 200) >= this.searchRoot.y + this.spaceHeight) {
                System.out.println("RETURNING TO ROOT ================");
                return this.searchRoot;
            }
        }
        return new KoalaLocation(n, n2);
    }

    public void eventHappened(KoalaTaskEvent koalaTaskEvent) {
        if (this.failureHandler != null) {
            System.out.println("ZigZagSearchPattern: Reporting failure");
            this.failureHandler.handleComponentFailure((Object)koalaTaskEvent, (TranquilComponent)this);
        }
    }

    @Override
    public void startSearch() throws RemoteException {
        if (this.zThread != null) {
            this.stopSearch();
        }
        System.out.println("ZIGZAG POWER NOW");
        KoalaLocation koalaLocation = this.locator.getTopLeft();
        KoalaLocation koalaLocation2 = this.locator.getTopRight();
        KoalaLocation koalaLocation3 = this.locator.getBottomLeft();
        KoalaLocation koalaLocation4 = this.locator.getBottomRight();
        this.spaceWidth = koalaLocation4.x - koalaLocation3.x - 400;
        System.out.println("Space is " + this.spaceWidth + " mm wide!");
        this.spaceHeight = koalaLocation.y - koalaLocation3.y - 1200;
        System.out.println("Space is " + this.spaceHeight + " mm high!");
        this.searchRoot = new KoalaLocation(koalaLocation3.x, koalaLocation3.y + 600);
        System.out.println("Root is " + this.searchRoot + " (minX, minY)");
        this.movingLeft = true;
        try {
            KoalaLocation koalaLocation5 = this.locator.getRobotLocation(this.iAmRed);
            if (koalaLocation5 != null) {
                this.currentWaypoint = this.nearestWaypoint(koalaLocation5);
                System.out.println("ZigZagSearchPattern: Desired waypoint: " + this.currentWaypoint);
                if (this.zThread != null) {
                    this.zThread.halt();
                }
                this.zThread = new ZThread();
                this.zThread.start();
            } else {
                System.out.println("ZigZagSearchPattern cannot start: SkyCam cannot find me");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("ZigZagSearchPattern cannot start: SkyCam broken");
        }
    }

    @Override
    public void stopSearch() throws RemoteException {
        System.out.println("ZIGZAG MUST STOP");
        this.zThread.halt();
        System.out.println("ZIGZAG HAS STOPPED");
    }

    @Override
    public KoalaVector getDirection() {
        return this.direction;
    }

    public class ZThread
    extends Thread {
        private volatile boolean running = true;

        public void run() {
            long l = System.currentTimeMillis();
            while (this.running) {
                try {
                    KoalaLocation koalaLocation = ZigZagSearchPattern.this.locator.getRobotLocation(ZigZagSearchPattern.this.iAmRed);
                    if (koalaLocation == null || koalaLocation.heading == 999) {
                        System.out.println("ZigZagSearchPattern: LOST");
                        ZigZagSearchPattern.this.stopSearch();
                        ZigZagSearchPattern.this.eventHappened(new FailedEvent(null));
                        ZigZagSearchPattern.this.direction = new KoalaVector(0.0, 0.0);
                    } else {
                        KoalaVector koalaVector = koalaLocation.getVectorTo(ZigZagSearchPattern.this.currentWaypoint);
                        if (koalaVector.magnitude() < 340.0) {
                            System.out.println("ZigZagSearchPattern: At waypoint: " + ZigZagSearchPattern.this.currentWaypoint);
                            l = System.currentTimeMillis();
                            ZigZagSearchPattern.this.currentWaypoint = ZigZagSearchPattern.this.nextWaypoint(ZigZagSearchPattern.this.currentWaypoint);
                            System.out.println("ZigZagSearchPattern: Next: " + ZigZagSearchPattern.this.currentWaypoint);
                            koalaVector = koalaLocation.getVectorTo(ZigZagSearchPattern.this.currentWaypoint);
                        }
                        int n = koalaVector.direction() - koalaLocation.heading;
                        ZigZagSearchPattern.this.direction = KoalaVector.createFromMagAndDir(2.0, n);
                        if (System.currentTimeMillis() - l > 15000L && ZigZagSearchPattern.this.currentWaypoint != ZigZagSearchPattern.this.searchRoot) {
                            System.out.println("ZigZagSearchPattern: Not making progress");
                            ZigZagSearchPattern.this.eventHappened(new FailedEvent(null));
                        }
                    }
                    if (!this.running) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (RemoteException remoteException) {
                    System.out.println("ZigZagSearchPattern: SkyCam broken");
                    try {
                        ZigZagSearchPattern.this.stopSearch();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ZigZagSearchPattern.this.eventHappened(new NetworkFailedEvent(null, "LocationServer", remoteException.getClass().getName()));
                }
            }
        }

        public void halt() {
            this.running = false;
            if (Thread.currentThread() != ZigZagSearchPattern.this.zThread) {
                try {
                    ZigZagSearchPattern.this.zThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ZigZagSearchPattern.this.direction = new KoalaVector(0.0, 0.0);
        }
    }

    public class RemoteProxy
    extends UnicastRemoteObject
    implements SearchPattern {
        public void startSearch() throws RemoteException {
            ZigZagSearchPattern.this.startSearch();
        }

        public void stopSearch() throws RemoteException {
            ZigZagSearchPattern.this.stopSearch();
        }
    }
}

