/*
 * Decompiled with CFR 0.152.
 */
package koala.planning;

import com.hopstepjump.backbone.RemoteBackbone;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Vector;
import koala.planning.AbstractLocalPlanInterpreter;
import koala.planning.InterpreterException;
import koala.planning.LocalPlanInterpreter;
import koala.planning.Plan;
import koala.planning.PlanProposition;
import koala.remote.RemoteBallGrabber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArmPlanInterpreter
extends AbstractLocalPlanInterpreter {
    private Vector<String> actionTrace = new Vector();
    private RemoteBackbone localBackbone;
    private boolean unloading;
    private boolean ballAtDepot;

    @Override
    public void execute(Plan plan, Map<String, String> map) throws InterpreterException, RemoteException {
        this.peers = map;
        try {
            this.localBackbone = (RemoteBackbone)Naming.lookup("remotebackbone");
        }
        catch (Exception exception) {
            System.err.println("ArmPlanInterpreter: CANNOT GET LOCAL BACKBONE");
        }
        if (this.localBackbone != null) {
            this.execute(plan);
        }
    }

    @Override
    public boolean evaluateProposition(PlanProposition planProposition) throws InterpreterException, RemoteException {
        System.out.println(planProposition);
        if (planProposition.operator.equals("=")) {
            String string = planProposition.predicate.elementAt(0);
            if (string.equals("ball_at_depot")) {
                return this.ballAtDepot == planProposition.value.equals("1");
            }
            if (string.equals("unloading")) {
                return planProposition.value.equals("1") == this.unloading;
            }
            return this.evaluateRemoteProposition(planProposition);
        }
        throw new InterpreterException("Proposition " + planProposition + " cannot be evaluated here.");
    }

    @Override
    public void performAction(Vector<String> vector) throws InterpreterException, RemoteException {
        System.out.println("ACTION:" + vector);
        String string = vector.elementAt(0);
        this.actionTrace.add(string);
        if (string.equals("unload")) {
            System.out.println("Trying to unload");
            final RemoteBallGrabber remoteBallGrabber = (RemoteBallGrabber)this.localBackbone.getInterfaceInstance("koala.remote.RemoteBallGrabber");
            this.unloading = true;
            Thread thread = new Thread(){

                public void run() {
                    try {
                        remoteBallGrabber.searchAndPickup();
                        ArmPlanInterpreter.this.ballAtDepot = true;
                        ArmPlanInterpreter.this.unloading = false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        ArmPlanInterpreter.this.componentFailure("unload", exception);
                    }
                }
            };
            thread.start();
            ArmPlanInterpreter.sleep(10000L);
        }
        throw new InterpreterException("Action " + string + " cannot be executed here.");
    }

    private void componentFailure(String string, Exception exception) {
        if (exception == null) {
            System.out.println("FAILED (component failure on action " + string + ")");
        } else {
            System.out.println("FAILED (component failure on action " + string + ", " + exception.getClass().getName() + ")");
        }
        for (String string2 : this.actionTrace) {
            System.out.println("       " + string2);
        }
        System.exit(-1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RemoteProxy
    extends UnicastRemoteObject
    implements LocalPlanInterpreter {
        @Override
        public void execute(Plan plan, Map<String, String> map) throws InterpreterException, RemoteException {
            ArmPlanInterpreter.this.execute(plan, map);
        }

        @Override
        public boolean evaluateProposition(PlanProposition planProposition) throws InterpreterException, RemoteException {
            return ArmPlanInterpreter.this.evaluateProposition(planProposition);
        }

        @Override
        public void performAction(Vector<String> vector) throws InterpreterException, RemoteException {
            ArmPlanInterpreter.this.performAction(vector);
        }
    }
}

