/*
 * Decompiled with CFR 0.152.
 */
package koala.task;

import com.hopstepjump.backbone.api.req;
import java.awt.Color;
import java.awt.Point;
import koala.Koala;
import koala.KoalaCamera;
import koala.KoalaSensorReading;
import koala.KoalaVector;
import koala.KoreCamera;
import koala.task.KoalaTask;

public class VisualFollowingTask
extends KoalaTask {
    @req(value="camera")
    public KoalaCamera camera;

    public VisualFollowingTask() {
    }

    public VisualFollowingTask(Koala koala) {
        super(koala);
        this.camera = KoreCamera.getInstance();
    }

    public void initialise(Object[] objectArray) throws IllegalArgumentException {
        this.camera = KoreCamera.getInstance();
    }

    private KoalaVector obstacleVector(KoalaSensorReading koalaSensorReading, double d) {
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < 3; ++n) {
            if (koalaSensorReading.leftSensors[n] > 250) {
                d2 += (double)koalaSensorReading.leftSensors[n] * Math.cos(Math.toRadians(0.0));
                d3 += (double)koalaSensorReading.leftSensors[n] * Math.sin(Math.toRadians(0.0));
            }
            if (koalaSensorReading.rightSensors[n] <= 250) continue;
            d2 += (double)koalaSensorReading.rightSensors[n] * Math.cos(Math.toRadians(0.0));
            d3 += (double)koalaSensorReading.rightSensors[n] * Math.sin(Math.toRadians(0.0));
        }
        if (koalaSensorReading.leftSensors[3] > 250) {
            d2 += (double)(2 * koalaSensorReading.leftSensors[3]) * Math.cos(Math.toRadians(45.0));
            d3 += (double)(2 * koalaSensorReading.leftSensors[3]) * Math.sin(Math.toRadians(45.0));
        }
        if (koalaSensorReading.rightSensors[3] > 250) {
            d2 += (double)(2 * koalaSensorReading.rightSensors[3]) * Math.cos(Math.toRadians(-45.0));
            d3 += (double)(2 * koalaSensorReading.rightSensors[3]) * Math.sin(Math.toRadians(-45.0));
        }
        for (n = 4; n < 6; ++n) {
            if (koalaSensorReading.leftSensors[n] > 250) {
                d2 += Math.cos(Math.toRadians(90.0));
                d3 += Math.sin(Math.toRadians(90.0));
            }
            if (koalaSensorReading.rightSensors[n] <= 250) continue;
            d2 += Math.cos(Math.toRadians(-90.0));
            d3 += Math.sin(Math.toRadians(-90.0));
        }
        if (koalaSensorReading.leftSensors[6] > 250) {
            d2 += Math.cos(Math.toRadians(135.0));
            d3 += Math.sin(Math.toRadians(135.0));
        }
        if (koalaSensorReading.rightSensors[6] > 250) {
            d2 += Math.cos(Math.toRadians(-135.0));
            d3 += Math.sin(Math.toRadians(-135.0));
        }
        if (koalaSensorReading.leftSensors[7] > 250) {
            d2 += Math.cos(Math.toRadians(180.0));
            d3 += Math.sin(Math.toRadians(180.0));
        }
        if (koalaSensorReading.rightSensors[7] > 250) {
            d2 += Math.cos(Math.toRadians(-180.0));
            d3 += Math.sin(Math.toRadians(-180.0));
        }
        KoalaVector koalaVector = new KoalaVector(d2, d3);
        koalaVector.normalise();
        koalaVector.scale(5.0 * d);
        return koalaVector;
    }

    public void run() {
        int[] nArray = new int[]{70, 255, -1, 10, -1, 50};
        try {
            while (this.running) {
                Point point = this.camera.getSpotPosition(Color.red, nArray);
                if (point == null) {
                    System.out.println("not found.");
                    this.motors.setSpeed(0, 0);
                } else {
                    KoalaVector koalaVector = this.obstacleVector(this.sensors.readProximitySensors(), 2.0);
                    int n = point.x - 320;
                    int n2 = 240 - point.y;
                    int n3 = n2 / 6;
                    int n4 = n / 16;
                    this.motors.setSpeed(n3 + n4, n3 - n4);
                }
                Thread.sleep(100L);
            }
            this.motors.setSpeed(0, 0);
        }
        catch (InterruptedException interruptedException) {
            this.running = false;
        }
    }
}

