class CMetaverse;

class CCalculationThreads{
    enum CalculationState { 
        Waiting             // slot is free and is waiting for data
        , Ready             // data is set ready for a calculation to run
        , Running           // A thread is running the calculation
    };
    struct Calculation {
        CalculationState    m_State;
        int                 m_iBaseAmp;
        CComplexVector      m_cvWorkSpaceIn;
        CComplexVector      m_cvWorkSpaceOut;
    };

    enum { INITIAL_WORKSPACE_LENGTH = 128 };// Maximum workspace allocated 

    int                 m_iThreads;         // Number of threads
    BOOL                m_bTerminate;       // Terminate the threads?
    Calculation         *m_pCalculation;    // Calculations to perform    

    CSemaphore          m_WorkToDo;         // Manages Work available
    CSemaphore          m_FreeThreads;      // Manages threads availavle
    CMutex              m_ObjectMutex;      // Mutex for access to this

    CQList<CGateGroup>  *m_pListGates;      // Ptr to list of gates being simulated
    CBaseComplexVector  *m_pcvAmps;         // Ptr to amplitudes of the simulation
    int                 *m_piGatePinMask;   // Ptr to masks for each gate's pins
    int                 m_iPinMask;         // Pin mask for the entire set of gates
    int                 m_iBaseAmpBits;     // Base amplitude being simulated

public:
    CCalculationThreads( int iThreads, int iPriority );
    ~CCalculationThreads( );

    void WaitForCompletion();               // Blocks until threads stop calculating
    void SetCalcData( CQList<CGateGroup>    &listGates
                    , CBaseComplexVector    &cvAmps
                    , int                   *piGatePinMask
                    , int                   iBaseAmpBits
                    , int                   iPinMask
                    );                      // Sets data for the calculations

    void CalcGatesAsync( int iBaseAmp );    // Queues a calculation

protected:
    static UINT ThreadStart( LPVOID lpVoid );   // Entry point for threads
    UINT ThreadMainLoop( );                     // Main loop for threads

    void CalcGate( int iBaseAmp, int iCalc ); // Called to calculate 
};
