
#ifndef _SIMULATE_THREADED_H_
#define _SIMULATE_THREADED_H_

// Ooops, can't multithread like this. Don't use this class
class CMetaverse;

class CSimulateThreaded {
    CMetaverse          *m_pMetaverse;
    CComplexVector      &m_cvAmps;
    CCircuit            *m_pCircuit;
    CQList<CGateGroup>  &m_listGroups;

    CSemaphore          m_FreeProcesses;
    CSemaphore          m_FreeGroups;
    CMutex              m_ObjectMutex;
    CEvent              m_SimulationFinished;

    int                 m_iCurrentGroup;
    int                 m_iThreadsRunning;
    int                 m_iWorkDone;

    enum GroupState { Blocked, Ready, Running, Finished } *m_aGroupState;
public:
    CSimulateThreaded( CMetaverse           *pMetaverse
                     , CComplexVector       &cvAmps
                     , CCircuit             *pCircuit
                     , CQList<CGateGroup>   &listGroups
                     , int                  iMaxRunningThreads
                     );
    ~CSimulateThreaded();

    void StartSimulation( int iPriority );
    void WaitForTermination( );

protected:
    UINT SimulateGroups( );
    static UINT SimulateGroupsThreadStart( LPVOID lpVoid );
    int UnblockReadyGroups( );

};



#endif

