
#ifndef _CIRCUIT_H_
#define _CIRCUIT_H_

class CGate;
class CMetaverse;
class CInputPin;
class COutputPin;

#include "qlist.h"

class CCircuit {
    
    // Maximum number of quantum bits that any circuit is allowed to have.
    enum { 
        MAX_INPUT_BITS = 32
    };

    char *m_szName;                     // First name of this circuit (e.g. filename)
    char *m_szCircuit;                  // Second name (e.g. circuit/function)
public:
    CQList<CGate *> m_listGates;        // Gates in the circuit
protected:
    BOOL            m_bOrdered;         // Is this list ordered?

    COutputPin      *m_pLastBit[MAX_INPUT_BITS]; // Pointers to last pin to output each bit

    int m_iInputBits;                   // Number of input bits
    int m_iOutputBits;                  // Number of output bits

    // construction / destruction
public:
    CCircuit( const char *szName, const char *szCircuit );
    ~CCircuit();

    // test circuit stuff
public:
    static CCircuit *CreateTestCircuit( int iCircuit, const char *szName, const char *szCircuit, int iSize, ostream &os );
	static BOOL SimpleTestCorrect( int iCircuit, int iSize, int iInitial, int iOutput );
    static int NumberOfCircuitTests() { return 7; }

    // Loading / storing
public:
	void LoadFrom( istream &is, ostream &os );

    // Attributes
public:
    int NumberOfGates() const { return m_listGates.Length(); }
    int NumberOfInputBits() const{ return m_iInputBits; }
    int NumberOfOutputBits() const { return m_iOutputBits; }

    const char *GetName() const { return m_szName; }
    const char *GetCircuit() const { return m_szCircuit; }

    BOOL Ordered() const { return m_bOrdered; }

    CGate* Gate( int i ) const {
        ASSERT( i >= 0 && i < NumberOfGates() ); 
        return m_listGates[ i ];
    }

    BOOL AllPinsConnected() const;

    // Gate Operations
public:
    CGate* AddGate( CGate *pGate );
    int FindGate( const CGate *pGate ) const;
    void OrderGates( );

    // Connections
public:
    void Connect( int iBitNumber, CInputPin *pInputPin );
    void NotifyConnect( COutputPin *pOutputPin, CInputPin *pInputPin );

    // Initialisation
public:
    void PrepareForProcessing();

    // Streaming
public:
    friend ostream& operator<<( ostream &os, CCircuit &Circuit );
};

#endif
