
template<class T>
CQList<T>::CQList( int iGrowSize )
: m_iGrowSize( iGrowSize )
, m_iArraySize( 0 )
, m_iLength( 0 )
, m_ptData( NULL )
, m_bSorted( TRUE )
{
    GrowTo( m_iGrowSize );
}

template<class T>
CQList<T>::CQList( const CQList<T> &tList)
: m_iGrowSize( tList.m_iGrowSize )
, m_iArraySize( 0 )
, m_iLength( 0 )
, m_ptData( NULL )
, m_bSorted( tList.m_bSorted )
{
    GrowTo( tList.m_iArraySize );
    Copy( tList );
}

template<class T>
CQList<T>& CQList<T>::operator=( const CQList<T> &tList )
{
    m_iGrowSize = tList.m_iGrowSize;
    m_bSorted = tList.m_bSorted;
    m_iArraySize = 0;
    
    GrowTo( tList.m_iArraySize, FALSE );
    Copy( tList );

    return *this;
}

template<class T>
void CQList<T>::Copy( const CQList<T> &tList )
{
    for( int i = 0; i < tList.Length(); i++ )
        m_ptData[i] = tList[i];

    m_iLength = tList.m_iLength;
}


template<class T>
CQList<T>::~CQList()
{
    if( m_ptData )
        delete [] m_ptData;
}

template<class T>
void CQList<T>::GrowTo( int iNewArraySize, BOOL bCopy )
{
    if( iNewArraySize > m_iArraySize ){
        int iNextGrowPoint = m_iArraySize + m_iGrowSize;

        if( iNewArraySize < iNextGrowPoint )
            iNewArraySize = iNextGrowPoint;

        T *ptNewData = new T[ iNewArraySize ];

        if( m_ptData ){
            if( bCopy ){
                for( int i = 0; i < m_iLength; i++ )
                    ptNewData[i] = m_ptData[i];
            }

            delete [] m_ptData;
        }

        m_iArraySize = iNewArraySize;
        m_ptData = ptNewData;
    }
}

template<class T>
void CQList<T>::Append( const T& tData )
{
    GrowTo( m_iLength + 1 );
    m_ptData[ m_iLength++ ] = tData;

    m_bSorted = FALSE;
}

template<class T>
CQList<T>& CQList<T>::operator+=( const T& tData )
{
    if( Find( tData ) >= 0 )
        return *this;

    Append( tData );

    return *this;
}

template<class T>
CQList<T>& CQList<T>::operator+=( const CQList<T>& intList )
{
    for( int i = 0; i < intList.Length(); i++ )
        (*this) += intList[i];

    return *this;
}

template<class T>
int CQList<T>::Find( const T& tData ) const
{
    for( int i = 0; i < m_iLength; i++ )
        if( m_ptData[i] == tData )
            return i;

    return -1;
}

template<class T>
void CQList<T>::Empty( )
{
    m_iLength = 0;
}

template<class T>
void CQList<T>::Remove( const T& tData )
{
    int iPos = Find( tData );

    if( iPos >= 0 ){
        while( ++iPos < m_iLength )
            m_ptData[ iPos-1 ] = m_ptData[ iPos ];

        --m_iLength;
    }
}

template<class T>
void CQList<T>::Insert( int iPos, const T& tData )
{
    GrowTo( m_iLength + 1 );
    for( int i = m_iLength -1; i >= iPos; --i ){
        m_ptData[ i+1 ] = m_ptData[ i ];
    }

    m_ptData[ iPos ] = tData;
    ++m_iLength;
}

template<class T>
void CQList<T>::PartialOrderSort( )
{
    CQList<T> temp;

    for( int i = 0; i < Length(); i++ ){
        int iInsertBefore = temp.Length();
        int iInsertAfter = -1;
        for( int j = 0; j <temp.Length() ; ++j ){
            if( temp[j]<m_ptData[i] )
                iInsertAfter = j;
            else if (m_ptData[i]<temp[j] && j < iInsertBefore){
                iInsertBefore = j;
                break;
            }
        }

        if( iInsertBefore == temp.Length() && iInsertAfter == -1 ){
//            DBG_OUT( "\n\nappending " << m_ptData[i] );
            temp.Append( m_ptData[i] );
        } else{
            ASSERT( iInsertAfter < iInsertBefore );

//            DBG_OUT( "\n after, before = " << iInsertAfter << " " << iInsertBefore );
            if( iInsertBefore == temp.Length() ){
//                DBG_OUT( "\n\ninserting at pos " << iInsertAfter+1 << " " << m_ptData[i] );
                temp.Insert( iInsertAfter + 1, m_ptData[i] );
            } else {
//                DBG_OUT( "\n\ninserting at pos " << iInsertBefore << " " << m_ptData[i] );
                temp.Insert( iInsertBefore, m_ptData[i] );
            }
        }

//        DBG_OUT( "\nList is: " << temp );
    }

    m_bSorted = TRUE;
    (*this)=temp;
}

/*
template<class T>
void CQList<T>::Sort()
{
    if( !m_bSorted ){
#ifdef 0
        // Bubble sort
        T tTemp;
        for( int i = 0; i < m_iLength; i++ ){
            for( int j = 0; j < m_iLength - i - 1; j++ ){
                if( !(m_ptData[j] < m_ptData[j+1]) ){
                    tTemp = m_ptData[j];
                    m_ptData[j] = m_ptData[j+1];
                    m_ptData[j+1] = tTemp;
                }
            }
        }
#else        
        // Shell Sort

        int iGap[] = { 9, 5, 3, 2, 1 };
        T x;

        for( int k = 0; k < sizeof iGap / sizeof iGap[0]; k++ ){
            int iThisGap = iGap[ k ];

            for( int i = iThisGap; i < m_iLength; ++i ){
                x = m_ptData[i];

                for( int j = i-iThisGap; j>=0 && x<m_ptData[j]; j-=iThisGap )
                    m_ptData[j + iThisGap] = m_ptData[j];
                m_ptData[j + iThisGap] = x;
            }
        }
#endif
        m_bSorted = TRUE;
    }
}
*/

template<class T>
BOOL operator==( const CQList<T> &tList1, const CQList<T> &tList2 )
{
    if( tList1.Length() != tList2.Length() )
        return FALSE;

    if( tList1.m_bSorted && tList2.m_bSorted ){
        for( int i = 0; i < tList1.Length(); i++ )
            if( tList1[i] != tList2[i] )
                return FALSE;

        return TRUE;
    }

    for( int i = 0; i < tList1.Length(); i++ )
        if( tList2.Find( tList1[i] ) < 0 )
            return FALSE;

    return TRUE;
}

template<class T>
ostream& operator<<( ostream& os, const CQList<T> &tList )
{
    os << "[";

    for( int i = 0; i < tList.Length(); i++ ){
        os << tList[i];
        if( i != tList.Length() - 1 )
            os << ", ";
    }

    return (os << " ]");

}
