
#ifndef _QLIST_H_
#define _QLIST_H_

template<class T> class CQList {
    int m_iGrowSize;
    int m_iArraySize;
    int m_iLength;
    BOOL m_bSorted;

    T *m_ptData;

public:
    CQList( int iGrowSize = 50 );
    CQList( const CQList<T> &tList );
    ~CQList();

    CQList<T>& operator+=( const T& tData );
    CQList<T>& operator+=( const CQList<T> &tList );
    CQList<T>& operator=( const CQList<T> &tList );

    const T& operator[] (int n) const {
        ASSERT( n>=0 && n<m_iLength );
        return m_ptData[n];
    }

    int Length( ) const { return m_iLength; }
    BOOL IsEmpty( )  const { return m_iLength==0; }
    BOOL NotEmpty( ) const { return m_iLength> 0; }

    int Find ( const T& tData ) const;
    void Remove( const T& tData );
    void Empty( );

    void PartialOrderSort(  );
    //void Sort();

    friend BOOL operator==( const CQList<T> &tList1, const CQList<T> &tList2 );

    friend ostream& operator<<( ostream& os, const CQList<T> &intList );

private:
    void Copy( const CQList<T> &tList );

protected:
    void GrowTo( int iNewArraySize, BOOL bCopy = TRUE );
    void Append( const T& tData );
    void Insert( int iPos, const T& tData );
};

#include "qlist.cpp"


#endif