// Token.h

class CToken {
public:
    enum TokenType { TOKEN_NULL
                   , TOKEN_OPEN_BRACKET
                   , TOKEN_CLOSE_BRACKET
                   , TOKEN_COMMA
                   , TOKEN_OPEN_SQUARE_BRACKET
                   , TOKEN_CLOSE_SQUARE_BRACKET
                   , TOKEN_INT
                   , TOKEN_COMPLEX
                   , TOKEN_COLON_PLUS

                   , TOKEN_ERROR        // Guarunteed to be first error
                   , TOKEN_TOO_BIG
                   , TOKEN_EOF
                   , TOKEN_EXPECTED_COMPLEX
                   , TOKEN_ERROR_BAD_FLOAT
                   , TOKEN_ERROR_BAD_INT
                   , TOKEN_ERROR_COLON_NO_PLUS
    };
    
protected:
    TokenType m_TokenType;
    union {
        struct {
            double m_dReal;
            double m_dImag;
        };
        int m_iValue;
    };

public:
    CToken();
    CToken( istream &is );

    static CToken ReadNumber( istream &is );
    static CToken ReadToken( istream &is );
    static TokenType SkipBlanks( istream &is );
    static TokenType ReadTokenString( istream &is, char *szToken, int iMaxTokenSize );

    TokenType GetTokenType(){ return m_TokenType; }

    int GetInt() { ASSERT( m_TokenType == TOKEN_INT ); return m_iValue; }
    double GetReal() { ASSERT( m_TokenType == TOKEN_COMPLEX ); return m_dReal; }
    double GetImag() { ASSERT( m_TokenType == TOKEN_COMPLEX ); return m_dImag; }

    static const char *GetTokenString( TokenType tokenType );

    friend istream &operator>>( istream &is, CToken &token );
    friend ostream &operator<<( ostream &os, CToken &token );
};

