
#ifndef _GATEGROUP_H_
#define _GATEGROUP_H_

#include "qlist.h"

typedef CQList<const CGate *> GateList;

class CGateGroup{
    GateList m_listGates;
    GateList m_listDependsOn;

public:
    CGateGroup(  ){ };
    CGateGroup( const CGate *pGate );
    CGateGroup( CQList<CGate *>& listGates );

    void AddGate( const CGate *pGate );

    int NoGates() const { return m_listGates.Length(); }
    int NoDependsOn() const { return m_listDependsOn.Length(); }

    void ExpandGatesToSeparateGroups( CQList<CGateGroup> &listGateGroups ) const;

    const CGate* Gate( int n ) const { return m_listGates[n]; }
    const CGate* DependsOn( int n ) const{ return m_listDependsOn[n]; }

    friend BOOL operator==( const CGateGroup &gg1, const CGateGroup &gg2 );
    friend BOOL operator<( const CGateGroup &gg1, const CGateGroup &gg2 );
    friend BOOL operator<=( const CGateGroup &gg1, const CGateGroup &gg2 );

    friend ostream& operator<<( ostream& os, const CGateGroup& gg );

protected:
    void ComputeTransitiveEnclosure( const CGate *pGate );

};

#endif