// HaskellEvaluationDialog.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CHaskellEvaluationDialog dialog

class CHaskellEvaluationDialog : public CDialog
{
public:
    static CString m_strDefaultHaskellEval;
    static CString m_strDefaultInputFile;
    static CString m_strDefaultOutputFile;

    static int m_iDefaultBitsFrom;
    static int m_iDefaultBitsTo;
    static int m_iDefaultCircuitInputs;
    static int m_iDefaultCircuitOutputs;
    static int m_iDefaultBitsToOutput;
    static int m_iDefaultOutputFormat;

    static BOOL m_bDefaultOutputToFile;

// Construction
public:
	CHaskellEvaluationDialog(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CHaskellEvaluationDialog)
	enum { IDD = IDD_HASKELL_EVALUATION };
	CString	m_strHaskellEval;
	int		m_iBitsFrom;
	int		m_iBitsTo;
	CString	m_strInputFile;
	CString	m_strOutputFile;
	BOOL	m_bOutputToFile;
	int		m_iCircuitInputs;
	int		m_iCircuitOutputs;
	int		m_iBitsToOutput;
	int		m_iOutputFormat;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHaskellEvaluationDialog)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	void FileBrowse( UINT nID, BOOL bOpen );
	void EnableSelectBits( BOOL bEnable );
	void EnableInputFromBrowse( BOOL bEnable );
	void EnableOutputToFileBrowse( BOOL bEnable );
    virtual void OnOK();

	// Generated message map functions
	//{{AFX_MSG(CHaskellEvaluationDialog)
	afx_msg void OnRadioInputFrom();
	afx_msg void OnRadioQuantumFact();
	afx_msg void OnRadioCircuitInputs();
	virtual BOOL OnInitDialog();
	afx_msg void OnOutputToFile();
	afx_msg void OnRadioSelectBits();
	afx_msg void OnRadioOutputBits();
	afx_msg void OnInputFileBrowse();
	afx_msg void OnOutputFileBrowse();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
