#include "stdafx.h"
#include "qexception.h"
#include "matrix.h"
#include "pin.h"
#include "gate.h"
#include "circuit.h"


// CPin::CPin(  )
//
// default constructor
CPin::CPin(  )
: m_pConnectedTo( NULL )
, m_iBitNumber( -1 )
{

}

// CPin::SetParent( CGate *pParentGate )
// 
// Set our parent gate. Returns our old parent
CGate *CPin::SetParent( CGate *pParentGate )
{
    CGate *pOldParent = m_pParentGate;
    m_pParentGate = pParentGate;

    return pOldParent;
}

void CPin::ConnectTo( CPin *pOtherPin )
{
    // Perform ASSERTs on areas which we should have checked by now
    // Make sure that the other pin is valid
    ASSERT( pOtherPin );

    // Make sure we both have parent gates and that they are not the same
    ASSERT( ParentGate() 
            && pOtherPin->ParentGate() 
            && ParentGate() != pOtherPin->ParentGate()
            );

    // Make sure that we both belong in the same circuit.
    ASSERT( ParentGate()->ParentCircuit() 
            && ParentGate()->ParentCircuit() == pOtherPin->ParentGate()->ParentCircuit()
            );

    // THROW errors on areas which the user may inadvertently get wrong
    if( m_pConnectedTo ) QTHROW( "Pin connect on gate " << m_pParentGate->Name() << ". Pin already connected");
    if( pOtherPin->m_pConnectedTo ) QTHROW( "Pin connect on gate " << m_pParentGate->Name() << ". Destination pin already connected");
    if( pOtherPin->Direction() == Direction() ) QTHROW( "Pin connect on gate " << m_pParentGate->Name() << ". Attempted to connect like pins");

    // Find out which pin is the input and which is the output
    CInputPin *pInputPin;
    COutputPin *pOutputPin;

    // Cast with run time checking
    if( Direction() == InputPin ){
        pInputPin = dynamic_cast<CInputPin *>(this);
        pOutputPin = dynamic_cast<COutputPin *>(pOtherPin);
    } else {
        pInputPin = dynamic_cast<CInputPin *>(pOtherPin);
        pOutputPin = dynamic_cast<COutputPin *>(this);
    }

    // Can't connect to a pin unless there is a path back to a source gate
    if( !pOutputPin->HasValidBitNumber() ) QTHROW( "Pin connect on gate " << m_pParentGate->Name() << "Connection out of order");

    // Set the data
    pInputPin->BitNumber() = pOutputPin->BitNumber();
    pInputPin->ParentGate()->SetOutputBitNumbers();

    m_pConnectedTo = pOtherPin;
    pOtherPin->m_pConnectedTo = this;

    // Inform the circuit of a change in connection
    ParentGate()->ParentCircuit()->NotifyConnect( pOutputPin, pInputPin );
}