// quantumView.cpp : implementation of the CQuantumView class
//

#include "stdafx.h"
#include "quantum.h"

#include "quantumDoc.h"
#include "quantumView.h"

#include "SimpleTestDialog.h"
#include "MaxSimpleTestSizeDialog.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQuantumView

IMPLEMENT_DYNCREATE(CQuantumView, CEditView)

BEGIN_MESSAGE_MAP(CQuantumView, CEditView)
	//{{AFX_MSG_MAP(CQuantumView)
	ON_COMMAND(ID_QUANTUM_GO, OnQuantumGo)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_COMMAND(ID_RANDOM_TESTS, OnRandomTests)
	ON_COMMAND(ID_NORMAL_PRIORITY, OnNormalPriority)
	ON_COMMAND(ID_BELOW_NORMAL_PRIORITY, OnBelowNormalPriority)
	ON_UPDATE_COMMAND_UI(ID_BELOW_NORMAL_PRIORITY, OnUpdateBelowNormalPriority)
	ON_UPDATE_COMMAND_UI(ID_NORMAL_PRIORITY, OnUpdateNormalPriority)
	ON_UPDATE_COMMAND_UI(ID_QUANTUM_GO, OnUpdateQuantumGo)
	ON_UPDATE_COMMAND_UI(ID_RANDOM_TESTS, OnUpdateRandomTests)
	ON_COMMAND(ID_SINGLE_TEST_CIRCUIT, OnSingleTestCircuit)
	ON_COMMAND(ID_SIMPLE_SIMULATION, OnSimpleSimulation)
	ON_COMMAND(ID_EFFICIENT_SIMULATION, OnEfficientSimulation)
	ON_UPDATE_COMMAND_UI(ID_EFFICIENT_SIMULATION, OnUpdateEfficientSimulation)
	ON_UPDATE_COMMAND_UI(ID_SIMPLE_SIMULATION, OnUpdateSimpleSimulation)
	ON_COMMAND(ID_QUANTUM_VECTORS_SPARSE, OnQuantumVectorsSparse)
	ON_UPDATE_COMMAND_UI(ID_QUANTUM_VECTORS_SPARSE, OnUpdateQuantumVectorsSparse)
	ON_COMMAND(ID_QUANTUM_VECTORS_STATIC, OnQuantumVectorsStatic)
	ON_UPDATE_COMMAND_UI(ID_QUANTUM_VECTORS_STATIC, OnUpdateQuantumVectorsStatic)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CEditView::OnFilePrintPreview)
    // Ranges
    ON_COMMAND_RANGE(ID_QUANTUM_MAXIMUMTHREADS_1, ID_QUANTUM_MAXIMUMTHREADS_8, OnQuantumMaximumThreads )
    ON_UPDATE_COMMAND_UI_RANGE(ID_QUANTUM_MAXIMUMTHREADS_1, ID_QUANTUM_MAXIMUMTHREADS_8, OnUpdateQuantumMaximumThreads )

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQuantumView construction/destruction

CQuantumView::CQuantumView()
{
	// TODO: add construction code here

}

CQuantumView::~CQuantumView()
{
}

BOOL CQuantumView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	BOOL bPreCreated = CEditView::PreCreateWindow(cs);
	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// Enable word-wrapping
    cs.style |= ES_READONLY;

	return bPreCreated;
}

/////////////////////////////////////////////////////////////////////////////
// CQuantumView drawing

void CQuantumView::OnDraw(CDC* pDC)
{
	CQuantumDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CQuantumView printing

BOOL CQuantumView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default CEditView preparation
	return CEditView::OnPreparePrinting(pInfo);
}

void CQuantumView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// Default CEditView begin printing.
	CEditView::OnBeginPrinting(pDC, pInfo);
}

void CQuantumView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// Default CEditView end printing
	CEditView::OnEndPrinting(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CQuantumView diagnostics

#ifdef _DEBUG
void CQuantumView::AssertValid() const
{
	CEditView::AssertValid();
}

void CQuantumView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CQuantumDoc* CQuantumView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CQuantumDoc)));
	return (CQuantumDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CQuantumView message handlers

void CQuantumView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
    SetText( GetDocument()->GetOutputString() );
}

void CQuantumView::OnQuantumGo() 
{
    GetDocument()->QuantumGo( CQuantumDoc::RunLoadedCircuit, 0 );
}

int CQuantumView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CEditView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	m_nIDTimer = SetTimer( StringTimerID, StringTimerElapse, NULL );
	
	return 0;
}

void CQuantumView::OnDestroy() 
{
	CEditView::OnDestroy();
	
    if( m_nIDTimer );
	    KillTimer( m_nIDTimer );
	
}

// Set the window text to update every once in a while
// Should really get CQuantumDoc to derive a class from
// strstreambuf and override the sync method...
void CQuantumView::OnTimer(UINT nIDEvent) 
{
	CString str = GetDocument()->GetOutputString();

    if( str != m_strLastOutput ){
        m_strLastOutput = str;
        SetText( str );
    }

	CEditView::OnTimer(nIDEvent);
}

// Set the output text
// Converts \n to \r\n required by CEdit controls
void CQuantumView::SetText( const CString &cs )
{
    char c;
    char *strOutput = new char [65530];
    
    int i= 0, j, len = cs.GetLength();

    if( len > 65500 ) len = 65500;

    for( j = 0; j < len; j++ ){
        c = cs[ j ];

        if( c == '\n' ){
            strOutput[ i++ ] = '\r';
            strOutput[ i++ ] = '\n';
        } else
            strOutput[ i++ ] = c;
    }

    strOutput[ i ] = 0;

    // Set the text and scroll to the bottom.
    SetWindowText( strOutput );
    GetEditCtrl().SetSel( i, -1 );

    delete [] strOutput;

}

void CQuantumView::OnRandomTests() 
{
	// TODO: Add your command handler code here
    CMaxSimpleTestSizeDialog dlg;

    if( IDOK == dlg.DoModal() ){
        GetDocument()->QuantumGo( CQuantumDoc::RunContinuousTests
                                , dlg.m_iMaxTestSize 
                                , dlg.TestMask()
                                , dlg.AlgorithmMask()
                                );
    }

}

void CQuantumView::OnNormalPriority() 
{
	GetDocument()->SetCalculationPriority( THREAD_PRIORITY_NORMAL );
}

void CQuantumView::OnBelowNormalPriority() 
{
	GetDocument()->SetCalculationPriority( THREAD_PRIORITY_BELOW_NORMAL );
}

void CQuantumView::OnUpdateBelowNormalPriority(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( GetDocument()->GetCalculationPriority() == THREAD_PRIORITY_BELOW_NORMAL );
	
}

void CQuantumView::OnUpdateNormalPriority(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( GetDocument()->GetCalculationPriority() == THREAD_PRIORITY_NORMAL );
}

void CQuantumView::OnUpdateQuantumGo(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->Enable( GetDocument()->CanRunSimulation() );

}

void CQuantumView::OnUpdateRandomTests(CCmdUI* pCmdUI) 
{
#ifdef _DEBUG
    pCmdUI->Enable( TRUE );
#else
    pCmdUI->Enable( FALSE );
#endif

	
}

void CQuantumView::OnSingleTestCircuit() 
{
	// TODO: Add your command handler code here
    CSimpleTestDialog dlg;

    if( IDOK == dlg.DoModal() ){
        GetDocument()->LoadTestCircuit( dlg.m_iTestType, dlg.m_iTestSize );
        GetDocument()->QuantumGo( CQuantumDoc::RunSingleTest, 0 );
    }
	
}

void CQuantumView::OnSimpleSimulation() 
{
	GetDocument()->SetSimpleSimulations( TRUE );
}

void CQuantumView::OnEfficientSimulation() 
{
	GetDocument()->SetSimpleSimulations( FALSE );
}

void CQuantumView::OnUpdateSimpleSimulation(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( GetDocument()->GetSimpleSimulations() );
}

void CQuantumView::OnUpdateEfficientSimulation(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( !GetDocument()->GetSimpleSimulations() );
}

void CQuantumView::OnQuantumVectorsSparse() 
{
	GetDocument()->m_bSparseVectors = TRUE;
}

void CQuantumView::OnUpdateQuantumVectorsSparse(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( GetDocument()->m_bSparseVectors );
}

void CQuantumView::OnQuantumVectorsStatic() 
{
	GetDocument()->m_bSparseVectors = TRUE;
}

void CQuantumView::OnUpdateQuantumVectorsStatic(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( !GetDocument()->m_bSparseVectors );
}

void CQuantumView::OnQuantumMaximumThreads(UINT nID)
{
    int iMaxThreads = nID - ID_QUANTUM_MAXIMUMTHREADS_1;
    ASSERT( iMaxThreads >=0 && iMaxThreads < 8 );

    GetDocument()->m_iMaxThreads = iMaxThreads + 1;
}

void CQuantumView::OnUpdateQuantumMaximumThreads(CCmdUI* pCmdUI)
{
    int iMaxThreads = pCmdUI->m_nID - ID_QUANTUM_MAXIMUMTHREADS_1;
    ASSERT( iMaxThreads >=0 && iMaxThreads < 8 );

    pCmdUI->SetCheck( GetDocument()->m_iMaxThreads == iMaxThreads + 1 );
}
