/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.core;

import gnu.getopt.Getopt;
import java.util.ArrayList;
import java.util.List;
import kenya.CommandLineKenya;
import kenya.FileLoaderSaver;
import kenya.KenyaCore;
import kenya.sole.ui.core.EditingWindowUtilsFactory;
import mediator.subscription.MediationService;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.IJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

public class KenyaUI {
    public static final String VERSION = "4.2";
    private static boolean exiting = false;
    static final List exitListeners = new ArrayList();
    private static final AbstractJob exitJob = new AbstractJob(){

        public void execute() {
            ArrayList arrayList = new ArrayList(exitListeners);
            for (int i = 0; i < arrayList.size(); ++i) {
                AbstractJob abstractJob = (AbstractJob)arrayList.get(i);
                if (abstractJob == null) continue;
                abstractJob.execute();
            }
            JobDispatch.shutDownAllJobs();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    };
    public static final String guihelp = KenyaCore.commonhelp1 + KenyaCore.NEWLINE + "        kenya [options] kenyaFile [arguments]" + KenyaCore.NEWLINE + KenyaCore.NEWLINE + "If no options are specified, then the Kenya GUI will be used." + KenyaCore.NEWLINE + "Any options will cause Kenya to run on the command line, valid options are:" + KenyaCore.optionshelp;

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = CommandLineKenya.getOpts((String[])stringArray);
        block5: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    KenyaUI.printHelp();
                    System.exit(0);
                    continue block5;
                }
                case 110: {
                    KenyaCore.printLicense();
                    System.exit(0);
                    continue block5;
                }
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 105: 
                case 108: 
                case 112: 
                case 115: 
                case 116: 
                case 121: {
                    CommandLineKenya.main((String[])stringArray);
                    return;
                }
            }
            KenyaUI.printHelp();
            System.exit(1);
        }
        MediationService.getInstance().start();
        KenyaUI.addExitListener((IJob)new AbstractJob(){

            public void execute() {
                MediationService.getInstance().shutdown();
            }
        });
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                FileLoaderSaver fileLoaderSaver = new FileLoaderSaver();
                fileLoaderSaver.setPath(string);
                EditingWindowUtilsFactory.createAndOpenEditorWindow(fileLoaderSaver);
            }
        } else {
            EditingWindowUtilsFactory.createAndOpenEditorWindow();
        }
    }

    public static synchronized void exit() {
        if (!exiting) {
            exiting = true;
            JobDispatch.enqueueJob((AbstractJob)exitJob);
        }
    }

    public static synchronized boolean isExiting() {
        return exiting;
    }

    public static synchronized void addExitListener(IJob iJob) {
        if (iJob == null) {
            System.err.println("Attempt made to add a null exit listener.");
            throw new NullPointerException();
        }
        exitListeners.add(iJob);
    }

    public static synchronized void removeExitListener(AbstractJob abstractJob) {
        exitListeners.remove(abstractJob);
    }

    public static void printHelp() {
        System.out.println(guihelp);
    }
}

