/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor;

import kenya.interpreter.util.InterpreterInspectorContentProvider;
import kenya.interpreter.util.InterpreterInspectorListContentProvider;
import kenya.sole.ui.core.EditingWindow;
import kenya.sole.ui.editor.EditorPart;
import kenya.sole.ui.editor.interpreter.CarrotPainter;
import kenya.sole.ui.editor.interpreter.InterpreterContinueButtonSelectionListener;
import kenya.sole.ui.editor.interpreter.InterpreterInspectorLabelProvider;
import kenya.sole.ui.editor.interpreter.InterpreterInspectorListLabelProvider;
import kenya.sole.ui.editor.interpreter.InterpreterInterpretSelectionListener;
import kenya.sole.ui.editor.interpreter.InterpreterMouseListener;
import kenya.sole.ui.editor.interpreter.InterpreterStepModeButtonSelectionListener;
import kenya.sole.ui.event.DefaultPaintListener;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.ui.IButtonManager;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;

public class InterpreterPart
extends EditorPart {
    private volatile Button interpreterInterpretButton;
    private volatile StyledText interpreterStdOutText;
    private volatile Text interpreterStdInText;
    private volatile Button interpreterTrackButton;
    private volatile Button interpreterEOFButton;
    private volatile Button interpreterTerminateButton;
    private volatile Button interpreterStepModeButton;
    private volatile boolean interpreterStepMode = false;
    private volatile boolean interpreterTrackMode = false;
    private volatile Button interpreterContinueButton;
    private volatile TreeViewer interpreterInspector;
    private volatile ListViewer interpreterList;
    private volatile Text interpreterArgsText;
    private volatile Label interpreterArgsLabel;
    private String[] interpreterArgsResult;
    private volatile CarrotPainter carrotPainter;
    private volatile IStackMachineInformationProvider baseStackMachine;
    private volatile StackMachine stackMachine;

    public InterpreterPart(Composite composite, int n, IStatusLineManager iStatusLineManager, IButtonManager iButtonManager) {
        super(composite, n, iStatusLineManager, iButtonManager);
    }

    public void init() {
        super.init();
        this.carrotPainter = new CarrotPainter(this);
        this.editorText.addPaintListener((PaintListener)this.carrotPainter);
        InterpreterMouseListener interpreterMouseListener = new InterpreterMouseListener(this);
        this.editorText.addMouseListener((MouseListener)interpreterMouseListener);
        SashForm sashForm = new SashForm((Composite)this, 2304);
        this.interpreterList = new ListViewer((Composite)sashForm, 772);
        this.interpreterList.setContentProvider((IContentProvider)new InterpreterInspectorListContentProvider());
        this.interpreterList.setLabelProvider((IBaseLabelProvider)new InterpreterInspectorListLabelProvider(this));
        this.interpreterList.addSelectionChangedListener(new ISelectionChangedListener(){
            private Object firstElement = null;

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                if (iStructuredSelection.getFirstElement() != this.firstElement) {
                    InterpreterPart.this.getInterpreterInspector().setInput(iStructuredSelection.getFirstElement());
                    this.firstElement = iStructuredSelection.getFirstElement();
                }
                if (iStructuredSelection.getFirstElement() instanceof IMethodScope) {
                    IFunction iFunction = InterpreterPart.this.getBaseStackMachine().lookupFunction(((IMethodScope)iStructuredSelection.getFirstElement()).getCurrentMethod().getName());
                    StyledText styledText = InterpreterPart.this.getEditorTextWidget();
                    int n = styledText.getOffsetAtLine(iFunction.getPosition().getLineNumber() - 1);
                    styledText.setCaretOffset(n += iFunction.getPosition().getColumnNumber() - 1);
                    styledText.setSelection(n, n + iFunction.getPosition().getTokenLength());
                }
            }
        });
        this.interpreterInspector = new TreeViewer((Composite)sashForm, 772);
        this.interpreterInspector.setContentProvider((IContentProvider)new InterpreterInspectorContentProvider());
        this.interpreterInspector.setLabelProvider((IBaseLabelProvider)new InterpreterInspectorLabelProvider(this));
        this.interpreterInspector.setUseHashlookup(true);
        Composite composite = new Composite((Composite)this, 2048);
        FormLayout formLayout = new FormLayout();
        composite.setLayout((Layout)formLayout);
        this.interpreterInterpretButton = new Button(composite, 8);
        this.interpreterInterpretButton.setText("&Run");
        this.interpreterInterpretButton.setEnabled(false);
        this.interpreterStdOutText = new StyledText(composite, 2626);
        this.interpreterStdOutText.setText("");
        this.interpreterStdOutText.setEditable(false);
        this.interpreterStdOutText.setTabs(8);
        this.interpreterStdInText = new Text(composite, 2052);
        this.interpreterStdInText.setText("");
        this.interpreterStdInText.setEditable(true);
        this.interpreterStdInText.setEnabled(false);
        this.interpreterStdInText.setTabs(8);
        this.interpreterEOFButton = new Button(composite, 8);
        this.interpreterEOFButton.setText("Input EOF");
        this.interpreterEOFButton.setEnabled(false);
        this.interpreterTerminateButton = new Button(composite, 8);
        this.interpreterTerminateButton.setText("Terminate");
        this.interpreterTerminateButton.setEnabled(false);
        this.interpreterStepModeButton = new Button(composite, 2);
        this.interpreterStepModeButton.setText("Step Mode");
        this.interpreterStepModeButton.setEnabled(false);
        this.interpreterStepModeButton.addSelectionListener((SelectionListener)new InterpreterStepModeButtonSelectionListener(this));
        this.setInterpreterStepMode(this.interpreterStepModeButton.getSelection());
        this.interpreterContinueButton = new Button(composite, 8);
        this.interpreterContinueButton.setText("Continue");
        this.interpreterContinueButton.setEnabled(false);
        this.interpreterContinueButton.addSelectionListener((SelectionListener)new InterpreterContinueButtonSelectionListener(this));
        this.interpreterTrackButton = new Button(composite, 2);
        this.interpreterTrackButton.setText("Track");
        this.interpreterTrackButton.setEnabled(true);
        this.interpreterTrackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = Thread.currentThread().getPriority();
                Thread.currentThread().setPriority(10);
                InterpreterPart.this.setInterpreterTrackMode(InterpreterPart.this.interpreterTrackButton.getSelection());
                Thread.currentThread().setPriority(n);
            }
        });
        this.interpreterTrackButton.setSelection(true);
        this.setInterpreterTrackMode(this.interpreterTrackButton.getSelection());
        this.interpreterArgsLabel = new Label(composite, 16384);
        this.interpreterArgsLabel.setText("Arguments");
        this.interpreterArgsText = new Text(composite, 2052);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 1);
        formData.right = new FormAttachment((Control)this.interpreterTrackButton, -5);
        this.interpreterInterpretButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.interpreterContinueButton, -5);
        formData.width = 100;
        formData.bottom = new FormAttachment((Control)this.interpreterInterpretButton, 0, 1024);
        this.interpreterTrackButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.interpreterStepModeButton, -5);
        formData.width = 100;
        formData.bottom = new FormAttachment((Control)this.interpreterInterpretButton, 0, 1024);
        this.interpreterContinueButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.interpreterTerminateButton, -5);
        formData.width = 100;
        formData.bottom = new FormAttachment((Control)this.interpreterInterpretButton, 0, 1024);
        this.interpreterStepModeButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, -1);
        formData.width = 100;
        formData.bottom = new FormAttachment((Control)this.interpreterInterpretButton, 0, 1024);
        this.interpreterTerminateButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.interpreterInterpretButton, 5);
        formData.bottom = new FormAttachment((Control)this.interpreterStdInText, -5);
        formData.left = new FormAttachment(0, 1);
        formData.right = new FormAttachment(100, -1);
        this.interpreterStdOutText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 1);
        formData.bottom = new FormAttachment((Control)this.interpreterArgsText, -5);
        formData.right = new FormAttachment((Control)this.interpreterEOFButton, -5);
        this.interpreterStdInText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -1);
        formData.bottom = new FormAttachment((Control)this.interpreterArgsText, -5);
        formData.width = 100;
        formData.top = new FormAttachment((Control)this.interpreterStdInText, 0, 128);
        this.interpreterEOFButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 1);
        formData.bottom = new FormAttachment(100, -5);
        formData.top = new FormAttachment((Control)this.interpreterArgsText, 5, 128);
        this.interpreterArgsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -1);
        formData.left = new FormAttachment((Control)this.interpreterArgsLabel, 5);
        formData.bottom = new FormAttachment(100, -5);
        this.interpreterArgsText.setLayoutData((Object)formData);
        InterpreterInterpretSelectionListener interpreterInterpretSelectionListener = new InterpreterInterpretSelectionListener(this);
        this.interpreterInterpretButton.addSelectionListener((SelectionListener)interpreterInterpretSelectionListener);
        this.setWeights(new int[]{1, 1, 1});
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.interpreterInspector != null) {
            this.interpreterInspector.getControl().setFont(font);
            this.interpreterList.getControl().setFont(font);
        }
    }

    public void setSecondaryFont(Font font) {
        if (this.getEditorTextWidget() != null) {
            this.interpreterStdOutText.setFont(font);
            this.interpreterStdInText.setFont(font);
        }
    }

    public Font getSecondaryFont() {
        if (this.getEditorTextWidget() != null) {
            return this.interpreterStdInText.getFont();
        }
        return null;
    }

    protected void buildEditorContent(SashForm sashForm) {
        super.buildEditorContent(sashForm);
        this.editorText.setEditable(false);
        this.editorText.addPaintListener((PaintListener)new DefaultPaintListener(this));
    }

    public synchronized Button getInterpreterInterpretButton() {
        return this.interpreterInterpretButton;
    }

    public synchronized StyledText getInterpreterStdOutText() {
        return this.interpreterStdOutText;
    }

    public synchronized Text getInterpreterStdInText() {
        return this.interpreterStdInText;
    }

    public synchronized Button getInterpreterEOFButton() {
        return this.interpreterEOFButton;
    }

    public synchronized Button getInterpreterTerminateButton() {
        return this.interpreterTerminateButton;
    }

    public synchronized Button getInterpreterStepModeButton() {
        return this.interpreterStepModeButton;
    }

    public synchronized Button getInterpreterContinueButton() {
        return this.interpreterContinueButton;
    }

    public synchronized StackMachine getStackMachine() {
        return this.stackMachine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStackMachine(final StackMachine stackMachine) {
        if (Thread.currentThread().equals(this.getInterpreterInspector().getControl().getDisplay().getThread())) {
            InterpreterPart interpreterPart = this;
            synchronized (interpreterPart) {
                this.stackMachine = stackMachine;
                this.interpreterInspector.setInput((Object)stackMachine);
                this.interpreterList.setInput((Object)stackMachine);
            }
        } else {
            this.getInterpreterInspector().getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    InterpreterPart.this.setStackMachine(stackMachine);
                }
            });
        }
    }

    public synchronized Button getInterpreterTrackButton() {
        return this.interpreterTrackButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInterpreterTrackMode() {
        Object object = this.lock;
        synchronized (object) {
            return this.interpreterTrackMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterpreterTrackMode(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.interpreterTrackMode = bl;
        }
    }

    public synchronized TreeViewer getInterpreterInspector() {
        return this.interpreterInspector;
    }

    public synchronized ListViewer getInterpreterList() {
        return this.interpreterList;
    }

    public synchronized Text getInterpreterArgsText() {
        return this.interpreterArgsText;
    }

    public String[] getInterpreterArgs() {
        if (Thread.currentThread().equals(this.getInterpreterArgsText().getDisplay().getThread())) {
            this.setInterpreterArgsResult(EditingWindow.parseIntoArgs(this.getInterpreterArgsText().getText()));
        } else {
            this.getInterpreterArgsText().getDisplay().syncExec(new Runnable(){

                public void run() {
                    InterpreterPart.this.getInterpreterArgs();
                }
            });
        }
        return this.getInterpreterArgsResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterpreterArgsResult(String[] stringArray) {
        Object object = this.lock;
        synchronized (object) {
            this.interpreterArgsResult = stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getInterpreterArgsResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.interpreterArgsResult;
        }
    }

    public synchronized void setBaseStackMachine(IStackMachineInformationProvider iStackMachineInformationProvider) {
        this.baseStackMachine = iStackMachineInformationProvider;
    }

    public synchronized IStackMachineInformationProvider getBaseStackMachine() {
        return this.baseStackMachine;
    }

    public synchronized CarrotPainter getCarrotPainter() {
        return this.carrotPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionBlueCarrot(final ISourceCodeLocation iSourceCodeLocation) {
        if (Thread.currentThread().equals(this.getEditorTextWidget().getDisplay().getThread())) {
            InterpreterPart interpreterPart = this;
            synchronized (interpreterPart) {
                int n = iSourceCodeLocation.getLineNumber() - 1;
                int n2 = iSourceCodeLocation.getColumnNumber() - 1;
                int n3 = this.getEditorTextWidget().getOffsetAtLine(n) + n2;
                this.getCarrotPainter().setBlueCarrotOffset(n3);
                this.getInterpreterInspector().refresh();
            }
        } else {
            this.getEditorTextWidget().getDisplay().syncExec(new Runnable(){

                public void run() {
                    InterpreterPart.this.positionBlueCarrot(iSourceCodeLocation);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionBlueCarrot(final int n) {
        if (Thread.currentThread().equals(this.getEditorTextWidget().getDisplay().getThread())) {
            InterpreterPart interpreterPart = this;
            synchronized (interpreterPart) {
                this.getCarrotPainter().setBlueCarrotOffset(n);
                this.getInterpreterInspector().refresh();
            }
        } else {
            this.getEditorTextWidget().getDisplay().syncExec(new Runnable(){

                public void run() {
                    InterpreterPart.this.positionBlueCarrot(n);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterpreterStepMode(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.interpreterStepMode = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInterpreterStepMode() {
        Object object = this.lock;
        synchronized (object) {
            return this.interpreterStepMode;
        }
    }
}

