/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import kenya.FileLoaderSaver;
import kenya.sole.ui.core.EditingWindow;
import kenya.sole.ui.editor.EditorPart;
import kenya.sole.ui.editor.java.JavaExecuteButtonSelectionListener;
import kenya.sole.ui.editor.java.JavaTerminateButtonSelectionListener;
import kenya.sole.ui.event.DefaultPaintListener;
import kenya.ui.IButtonManager;
import kenya.ui.syntaxhighlighting.JavaLineStyler;
import mediator.IJavaCode;
import mediator.subscription.IJavaCodeReceiver;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JavaPart
extends EditorPart
implements IJavaCodeReceiver {
    private volatile Button javaExecuteButton;
    private volatile Button javaEOFButton;
    private volatile Button javaTerminateButton;
    private volatile Text javaStdInText;
    private volatile StyledText javaStdOutText;
    private volatile Text javaArgsText;
    private volatile Label javaArgsLabel;
    private String[] javaArgsResult;
    private volatile IJavaCode javaCode;
    private volatile FileLoaderSaver javaFileLoaderSaver = null;
    private volatile String javaClassName;
    private volatile boolean javaRunning = false;
    private final String javaDefaultClassName;

    public JavaPart(Composite composite, int n, IStatusLineManager iStatusLineManager, IButtonManager iButtonManager, String string) {
        super(composite, n, iStatusLineManager, iButtonManager);
        this.javaDefaultClassName = string;
    }

    public void init() {
        super.init();
        this.rebuildLineNumbers();
        Composite composite = new Composite((Composite)this, 2048);
        FormLayout formLayout = new FormLayout();
        composite.setLayout((Layout)formLayout);
        this.javaExecuteButton = new Button(composite, 8);
        this.javaExecuteButton.setText("E&xecute Java");
        this.javaTerminateButton = new Button(composite, 8);
        this.javaTerminateButton.setText("Terminate");
        this.javaTerminateButton.setEnabled(false);
        this.javaTerminateButton.addSelectionListener((SelectionListener)new JavaTerminateButtonSelectionListener(this));
        this.javaStdOutText = new StyledText(composite, 2626);
        this.javaStdOutText.setEditable(false);
        this.javaStdOutText.setTabs(8);
        this.javaStdInText = new Text(composite, 2052);
        this.javaStdInText.setEditable(true);
        this.javaStdInText.setEnabled(false);
        this.javaStdInText.setTabs(8);
        this.javaEOFButton = new Button(composite, 8);
        this.javaEOFButton.setText("Input EOF");
        this.javaEOFButton.setEnabled(false);
        this.javaArgsLabel = new Label(composite, 16384);
        this.javaArgsLabel.setText("Arguments");
        this.javaArgsText = new Text(composite, 2052);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 1);
        formData.right = new FormAttachment((Control)this.javaTerminateButton, -5);
        this.javaExecuteButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, -1);
        formData.width = 100;
        formData.bottom = new FormAttachment((Control)this.javaExecuteButton, 0, 1024);
        this.javaTerminateButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.javaExecuteButton, 5);
        formData.bottom = new FormAttachment((Control)this.javaStdInText, -5);
        formData.left = new FormAttachment(0, 1);
        formData.right = new FormAttachment(100, -1);
        this.javaStdOutText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 1);
        formData.bottom = new FormAttachment((Control)this.javaArgsText, -5);
        formData.right = new FormAttachment((Control)this.javaEOFButton, -5);
        this.javaStdInText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -1);
        formData.bottom = new FormAttachment((Control)this.javaArgsText, -5);
        formData.width = 100;
        formData.top = new FormAttachment((Control)this.javaStdInText, 0, 128);
        this.javaEOFButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 1);
        formData.bottom = new FormAttachment(100, -5);
        formData.top = new FormAttachment((Control)this.javaArgsText, 5, 128);
        this.javaArgsLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -1);
        formData.left = new FormAttachment((Control)this.javaArgsLabel, 5);
        formData.bottom = new FormAttachment(100, -5);
        this.javaArgsText.setLayoutData((Object)formData);
        JavaExecuteButtonSelectionListener javaExecuteButtonSelectionListener = new JavaExecuteButtonSelectionListener(this);
        this.javaExecuteButton.addSelectionListener((SelectionListener)javaExecuteButtonSelectionListener);
        this.setWeights(new int[]{2, 1});
    }

    public synchronized String getJavaDefaultClassName() {
        return this.javaDefaultClassName;
    }

    public void setSecondaryFont(Font font) {
        this.javaStdOutText.setFont(font);
        this.javaStdInText.setFont(font);
    }

    public Font getSecondaryFont() {
        if (this.getEditorTextWidget() != null) {
            return this.javaStdOutText.getFont();
        }
        return null;
    }

    protected void buildEditorContent(SashForm sashForm) {
        super.buildEditorContent(sashForm);
        this.setLineStyler((LineStyleListener)new JavaLineStyler());
        this.editorText.setEditable(false);
        this.editorText.addPaintListener((PaintListener)new DefaultPaintListener(this));
        this.editorText.addKeyListener(new KeyListener(){
            private static final String statusText = "Switch to the Kenya tab to edit the code.";

            public void keyPressed(KeyEvent keyEvent) {
                JavaPart.this.safeSetStatus(statusText);
            }

            public void keyReleased(KeyEvent keyEvent) {
                JavaPart.this.safeSetStatus(statusText);
            }
        });
    }

    public synchronized Button getJavaExecuteButton() {
        return this.javaExecuteButton;
    }

    public synchronized Button getJavaEOFButton() {
        return this.javaEOFButton;
    }

    public synchronized Button getJavaTerminateButton() {
        return this.javaTerminateButton;
    }

    public synchronized String getJavaClassName() {
        return this.javaClassName;
    }

    public synchronized void setJavaClassName(String string) {
        this.javaClassName = string;
    }

    public synchronized IJavaCode getJavaCode() {
        return this.javaCode;
    }

    public synchronized void setJavaCode(IJavaCode iJavaCode) {
        this.javaCode = iJavaCode;
    }

    public synchronized boolean isJavaRunning() {
        return this.javaRunning;
    }

    public synchronized void setJavaRunning(boolean bl) {
        this.javaRunning = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJavaArgsResult(String[] stringArray) {
        Object object = this.lock;
        synchronized (object) {
            this.javaArgsResult = stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getJavaArgsResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.javaArgsResult;
        }
    }

    public String[] getJavaArgs() {
        if (Thread.currentThread().equals(this.getJavaArgsText().getDisplay().getThread())) {
            this.setJavaArgsResult(EditingWindow.parseIntoArgs(this.getJavaArgsText().getText()));
        } else {
            this.getJavaArgsText().getDisplay().syncExec(new Runnable(){

                public void run() {
                    JavaPart.this.getJavaArgs();
                }
            });
        }
        return this.getJavaArgsResult();
    }

    public synchronized Text getJavaArgsText() {
        return this.javaArgsText;
    }

    public synchronized Text getJavaStdInText() {
        return this.javaStdInText;
    }

    public synchronized StyledText getJavaStdOutText() {
        return this.javaStdOutText;
    }

    public synchronized FileLoaderSaver getJavaFileLoaderSaver() {
        return this.javaFileLoaderSaver;
    }

    public synchronized void setJavaFileLoaderSaver(FileLoaderSaver fileLoaderSaver) {
        this.javaFileLoaderSaver = fileLoaderSaver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJavaAs() {
        if (Thread.currentThread().equals(this.getDisplay().getThread())) {
            JavaPart javaPart = this;
            synchronized (javaPart) {
                Shell shell = new Shell();
                FileDialog fileDialog = new FileDialog(shell, 8192);
                fileDialog.setFilterExtensions(new String[]{"*.java"});
                fileDialog.setText("Save Java translation file");
                String string = EditingWindow.lastDir;
                if (string == null && this.getJavaFileLoaderSaver() != null && (string = this.getJavaFileLoaderSaver().getDir()).length() == 0) {
                    string = null;
                }
                if (string != null) {
                    fileDialog.setFilterPath(string);
                }
                if (fileDialog.open() != null) {
                    string = fileDialog.getFilterPath();
                    File file = new File(fileDialog.getFilterPath(), fileDialog.getFileName());
                    if (this.getJavaFileLoaderSaver() == null) {
                        FileLoaderSaver fileLoaderSaver = new FileLoaderSaver();
                        fileLoaderSaver.setPath(file.getAbsolutePath());
                        this.setJavaFileLoaderSaver(fileLoaderSaver);
                    } else {
                        FileLoaderSaver fileLoaderSaver = this.getJavaFileLoaderSaver();
                        fileLoaderSaver.setPath(file.getAbsolutePath());
                    }
                    this.saveJava();
                }
            }
        } else {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    JavaPart.this.saveJavaAs();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJava() {
        if (Thread.currentThread().equals(this.getDisplay().getThread())) {
            JavaPart javaPart = this;
            synchronized (javaPart) {
                Shell shell = new Shell();
                FileLoaderSaver fileLoaderSaver = this.getJavaFileLoaderSaver();
                if (fileLoaderSaver == null || fileLoaderSaver.getPath() == null) {
                    this.saveJavaAs();
                    return;
                }
                try {
                    String string = fileLoaderSaver.getName();
                    if (string.indexOf(46) != -1) {
                        string = string.substring(0, string.indexOf(46));
                    }
                    if (this.getJavaCode() != null) {
                        BufferedReader bufferedReader = new BufferedReader(this.getJavaCode().getCode(string));
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = bufferedReader.read();
                        while (n != -1) {
                            stringBuffer.append((char)n);
                            n = bufferedReader.read();
                        }
                        bufferedReader.close();
                        fileLoaderSaver.saveFile(stringBuffer.toString());
                        this.safeSetStatus("Java translation saved to " + fileLoaderSaver.getPath());
                    } else {
                        MessageBox messageBox = new MessageBox(shell, 32);
                        messageBox.setText("Unable to save file.");
                        messageBox.setMessage("Can't save translation of faulty code.");
                        messageBox.open();
                        this.safeSetStatus("Can't save translation of faulty code.");
                    }
                }
                catch (IOException iOException) {
                    this.safeSetStatus("IOException occured when translating Kenya.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MessageBox messageBox = new MessageBox(shell, 32);
                    messageBox.setText("Unable to save file.");
                    messageBox.setMessage("Can not save Java into invalid file name '" + fileLoaderSaver.getName() + "'");
                    messageBox.open();
                    this.safeSetStatus("Can not save Java into invalid file name '" + fileLoaderSaver.getName() + "'");
                }
            }
        }
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                JavaPart.this.saveJava();
            }
        });
    }
}

