/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.interpreter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kenya.sole.ui.editor.InterpreterPart;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.ui.IButtonManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CarrotPainter
implements PaintListener {
    private static final int DIVISOR = 14;
    private final IButtonManager ibm;
    private final Image redCarrot;
    private final Image blueCarrot;
    private final int width;
    private final int height;
    private final StyledText text;
    private final List offsets = new ArrayList();
    private final Set locations = new HashSet();
    private volatile int blueCarrotOffset = 0;
    private volatile int scale = 0;
    private volatile int nScale = -1;
    private volatile int twidth = 0;
    private volatile int theight = 0;
    private volatile int offset;
    private volatile Point p;

    public CarrotPainter(InterpreterPart interpreterPart) {
        this.ibm = interpreterPart.getButtonManager();
        this.redCarrot = this.ibm.getImage("redCarrot");
        this.blueCarrot = this.ibm.getImage("blueCarrot");
        this.text = interpreterPart.getEditorTextWidget();
        this.width = this.redCarrot.getBounds().width;
        this.height = this.redCarrot.getBounds().height;
    }

    public synchronized void paintControl(PaintEvent paintEvent) {
        if (this.text.isDisposed() || !this.text.isVisible()) {
            return;
        }
        this.nScale = this.text.getFont().getFontData()[0].getHeight();
        if (this.scale != this.nScale) {
            this.scale = this.nScale;
            this.twidth = Math.max(1, this.width * this.scale / 14);
            this.theight = Math.max(1, this.height * this.scale / 14);
        }
        for (int i = 0; i < this.offsets.size(); ++i) {
            this.offset = (Integer)this.offsets.get(i);
            this.p = this.text.getLocationAtOffset(this.offset);
            this.p.x = this.p.x > this.redCarrot.getBounds().width / 2 ? (this.p.x -= this.redCarrot.getBounds().width / 2) : 0;
            if (this.p.x < paintEvent.x || this.p.x > paintEvent.x + paintEvent.width || this.p.y < paintEvent.y || this.p.y > paintEvent.y + paintEvent.height) continue;
            paintEvent.gc.drawImage(this.redCarrot, 0, 0, this.width, this.height, this.p.x, this.p.y, this.twidth, this.theight);
        }
        this.p = this.text.getLocationAtOffset(this.blueCarrotOffset);
        this.p.x = this.p.x > this.blueCarrot.getBounds().width / 2 ? (this.p.x -= this.blueCarrot.getBounds().width / 2) : 0;
        if (this.p.x >= paintEvent.x && this.p.x <= paintEvent.x + paintEvent.width && this.p.y >= paintEvent.y && this.p.y <= paintEvent.y + paintEvent.height) {
            paintEvent.gc.drawImage(this.blueCarrot, 0, 0, this.width, this.height, this.p.x, this.p.y, this.twidth, this.theight);
        }
    }

    public synchronized void addCarrot(int n, ISourceCodeLocation iSourceCodeLocation) {
        if (n < this.text.getCharCount() && n >= 0) {
            this.offsets.add(new Integer(n));
            this.locations.add(iSourceCodeLocation);
        }
    }

    public synchronized void clear() {
        this.offsets.clear();
        this.locations.clear();
        this.blueCarrotOffset = 0;
    }

    public synchronized void removeCarrot(int n, ISourceCodeLocation iSourceCodeLocation) {
        this.offsets.remove(new Integer(n));
        this.locations.remove(iSourceCodeLocation);
    }

    public synchronized boolean isCarrotAtOffset(int n) {
        return this.offsets.contains(new Integer(n));
    }

    public synchronized boolean isCarrotAtOffset(ISourceCodeLocation iSourceCodeLocation) {
        return this.locations.contains(iSourceCodeLocation);
    }

    public synchronized void setBlueCarrotOffset(int n) {
        this.blueCarrotOffset = n;
        this.p = this.text.getSelection();
        if (this.p.x > n || n > this.p.y) {
            this.text.setSelection(n);
            this.text.showSelection();
        }
        this.text.redraw();
    }

    public synchronized boolean carrotsSet() {
        return !this.offsets.isEmpty();
    }
}

