/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.interpreter;

import java.util.List;
import kenya.sole.ui.editor.InterpreterPart;
import kenya.sole.ui.editor.interpreter.CarrotPainter;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.stackMachine.IStackMachineInformationProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class InterpreterMouseListener
extends MouseAdapter {
    private final CarrotPainter ipl;
    private final StyledText interpreterText;
    private final InterpreterPart interpreter;

    public InterpreterMouseListener(InterpreterPart interpreterPart) {
        this.ipl = interpreterPart.getCarrotPainter();
        this.interpreterText = interpreterPart.getEditorTextWidget();
        this.interpreter = interpreterPart;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.x, mouseEvent.y);
        try {
            int n = this.interpreterText.getOffsetAtLocation(point);
            int n2 = this.interpreterText.getLineAtOffset(n);
            int n3 = n - this.interpreterText.getOffsetAtLine(n2);
            ++n2;
            ++n3;
            IStackMachineInformationProvider iStackMachineInformationProvider = this.interpreter.getBaseStackMachine();
            if (iStackMachineInformationProvider != null) {
                List list = iStackMachineInformationProvider.getDiscreteExecutionPointMarkersFromTheAST();
                int n4 = 0;
                ISourceCodeLocation iSourceCodeLocation = null;
                int n5 = Integer.MAX_VALUE;
                for (int i = 0; i < list.size(); ++i) {
                    ISourceCodeLocation iSourceCodeLocation2 = (ISourceCodeLocation)list.get(i);
                    int n6 = this.interpreterText.getOffsetAtLine(iSourceCodeLocation2.getLineNumber() - 1) + iSourceCodeLocation2.getColumnNumber() - 1;
                    if (Math.abs(n - n6) >= n5) continue;
                    n4 = n6;
                    iSourceCodeLocation = iSourceCodeLocation2;
                    n5 = Math.abs(n - n6);
                }
                if (this.ipl.isCarrotAtOffset(n4)) {
                    this.ipl.removeCarrot(n4, iSourceCodeLocation);
                } else {
                    this.ipl.addCarrot(n4, iSourceCodeLocation);
                }
                this.interpreterText.setSelection(n);
                this.interpreterText.redraw();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.interpreterText.setSelection(this.interpreterText.getCaretOffset());
            this.interpreterText.redraw();
        }
    }
}

