/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.java;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import kenya.sole.ui.core.KenyaUI;
import kenya.sole.ui.editor.JavaPart;
import kenya.sole.ui.util.StdOutWriter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.IJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

public class JavaExecuteButtonSelectionListener
extends SelectionAdapter {
    private static final String outputDir = System.getProperty("user.home") + File.separatorChar + ".kenyaTmp";
    private static final IJob deleteOnExitJob = new AbstractJob(){

        private void delDir(File file) {
            if (file.isFile()) {
                file.delete();
            } else {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.delDir(fileArray[i]);
                }
                file.delete();
            }
        }

        public void execute() {
            File file = new File(outputDir);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.delDir(fileArray[i]);
            }
        }
    };
    private static final int STDOUTCOLOR = 9;
    private static final int STDERRCOLOR = 3;
    private final JavaPart java;
    private final StyledText stdOutText;
    private final Text stdInText;
    private final Button executeJavaButton;
    private final Button eofButton;
    private final Button terminateButton;
    private final String delimiter;
    private KeyListener keyListener = null;
    private SelectionListener eofListener = null;
    private final Runnable enableStuff;
    private final Runnable disableStuff;

    public JavaExecuteButtonSelectionListener(JavaPart javaPart) {
        this.java = javaPart;
        this.stdOutText = javaPart.getJavaStdOutText();
        this.stdInText = javaPart.getJavaStdInText();
        this.executeJavaButton = javaPart.getJavaExecuteButton();
        this.eofButton = javaPart.getJavaEOFButton();
        this.terminateButton = javaPart.getJavaTerminateButton();
        this.delimiter = this.stdOutText.getLineDelimiter();
        this.enableStuff = new Runnable(){

            public void run() {
                JavaExecuteButtonSelectionListener.this.eofButton.setEnabled(true);
                JavaExecuteButtonSelectionListener.this.terminateButton.setEnabled(true);
                JavaExecuteButtonSelectionListener.this.terminateButton.setText("Terminate");
                JavaExecuteButtonSelectionListener.this.stdInText.setEnabled(true);
                JavaExecuteButtonSelectionListener.this.stdInText.setFocus();
            }
        };
        this.disableStuff = new Runnable(){

            public void run() {
                JavaExecuteButtonSelectionListener.this.terminateButton.setEnabled(false);
                JavaExecuteButtonSelectionListener.this.terminateButton.setText("Terminate");
                JavaExecuteButtonSelectionListener.this.eofButton.setEnabled(false);
                JavaExecuteButtonSelectionListener.this.stdInText.setText("");
                JavaExecuteButtonSelectionListener.this.stdInText.setEnabled(false);
                JavaExecuteButtonSelectionListener.this.executeJavaButton.setText("E&xecute Java");
                JavaExecuteButtonSelectionListener.this.executeJavaButton.setSelection(false);
                JavaExecuteButtonSelectionListener.this.executeJavaButton.setEnabled(true);
            }
        };
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.executeJavaButton.setEnabled(false);
        this.terminateButton.setEnabled(false);
        if (this.java.getJavaCode() == null) {
            this.executeJavaButton.setText("E&xecute Java");
        } else {
            this.executeJavaButton.setText("Executing...");
            try {
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new PipedInputStream(pipedOutputStream)));
                final PrintWriter printWriter = new PrintWriter(pipedOutputStream);
                PipedInputStream pipedInputStream = new PipedInputStream();
                final BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new PipedOutputStream(pipedInputStream)));
                PipedInputStream pipedInputStream2 = new PipedInputStream();
                final BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter(new PipedOutputStream(pipedInputStream2)));
                if (this.keyListener != null) {
                    this.stdInText.removeKeyListener(this.keyListener);
                }
                this.keyListener = new KeyAdapter(){

                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.character == '\r') {
                            keyEvent.doit = false;
                            String string = JavaExecuteButtonSelectionListener.this.stdInText.getText() + JavaExecuteButtonSelectionListener.this.delimiter;
                            JavaExecuteButtonSelectionListener.this.stdInText.setText("");
                            JavaExecuteButtonSelectionListener.this.stdOutText.append(string);
                            StyleRange styleRange = new StyleRange();
                            styleRange.start = JavaExecuteButtonSelectionListener.this.stdOutText.getCharCount() - string.length();
                            styleRange.length = string.length();
                            styleRange.foreground = JavaExecuteButtonSelectionListener.this.stdOutText.getDisplay().getSystemColor(6);
                            JavaExecuteButtonSelectionListener.this.stdOutText.setStyleRange(styleRange);
                            JavaExecuteButtonSelectionListener.this.stdOutText.setCaretOffset(JavaExecuteButtonSelectionListener.this.stdOutText.getCharCount());
                            JavaExecuteButtonSelectionListener.this.stdOutText.setSelection(JavaExecuteButtonSelectionListener.this.stdOutText.getCharCount());
                            JavaExecuteButtonSelectionListener.this.stdOutText.showSelection();
                            printWriter.write(string);
                            printWriter.flush();
                        }
                    }
                };
                this.stdInText.addKeyListener(this.keyListener);
                if (this.eofListener != null) {
                    this.eofButton.removeSelectionListener(this.eofListener);
                }
                this.eofListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        printWriter.close();
                        JavaExecuteButtonSelectionListener.this.stdInText.setEnabled(false);
                        JavaExecuteButtonSelectionListener.this.eofButton.setEnabled(false);
                    }
                };
                this.eofButton.addSelectionListener(this.eofListener);
                StdOutWriter stdOutWriter = new StdOutWriter(new InputStreamReader(pipedInputStream), this.stdOutText, 9);
                StdOutWriter stdOutWriter2 = new StdOutWriter(new InputStreamReader(pipedInputStream2), this.stdOutText, 3);
                AbstractJob abstractJob = new AbstractJob(){

                    public void execute() {
                        try {
                            JavaExecuteButtonSelectionListener.this.executeJavaButton.getDisplay().syncExec(JavaExecuteButtonSelectionListener.this.enableStuff);
                            JavaExecuteButtonSelectionListener.this.java.safeSetStatus("Java execution starting.");
                            JavaExecuteButtonSelectionListener.this.java.getJavaCode().execute(outputDir, JavaExecuteButtonSelectionListener.this.java.getJavaClassName(), bufferedReader, new BufferedWriter(printWriter), bufferedWriter, bufferedWriter2, JavaExecuteButtonSelectionListener.this.java.getJavaArgs());
                            bufferedWriter.close();
                            bufferedWriter2.close();
                            printWriter.close();
                            JavaExecuteButtonSelectionListener.this.java.setJavaRunning(false);
                            JavaExecuteButtonSelectionListener.this.executeJavaButton.getDisplay().syncExec(JavaExecuteButtonSelectionListener.this.disableStuff);
                            File file = new File(outputDir, JavaExecuteButtonSelectionListener.this.java.getJavaClassName() + ".java");
                            if (file.isFile()) {
                                file.delete();
                            }
                            JavaExecuteButtonSelectionListener.this.java.safeSetStatus("Execution of Java complete.");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                };
                this.stdOutText.setText("");
                this.stdOutText.setStyleRanges(new StyleRange[0]);
                this.java.setJavaRunning(true);
                JobDispatch.enqueueJob((AbstractJob)stdOutWriter);
                JobDispatch.enqueueJob((AbstractJob)stdOutWriter2);
                JobDispatch.enqueueJob((AbstractJob)abstractJob);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static {
        File file = new File(outputDir);
        if (!file.exists()) {
            if (!file.mkdir()) {
                System.err.println("Unable to create dir " + outputDir);
                KenyaUI.exit();
            }
        } else if (!file.isDirectory()) {
            System.err.println(outputDir + " should be a dir. Please remove " + outputDir + " and restart Kenya.");
        }
        KenyaUI.addExitListener(deleteOnExitJob);
    }
}

