/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.action.file;

import java.io.File;
import kenya.FileLoaderSaver;
import kenya.sole.ui.action.file.SavePromptAction;
import kenya.sole.ui.editor.KenyaPart;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenAction
extends Action {
    private final KenyaPart window;
    private String lastDir = null;

    public OpenAction(KenyaPart kenyaPart) {
        this.window = kenyaPart;
        this.setText("&Open in this window...@Ctrl+O");
        this.setToolTipText("Open a new file in this window");
    }

    public void run() {
        Object object;
        if (this.window.isModified()) {
            object = new SavePromptAction(this.window);
            ((SavePromptAction)((Object)object)).run();
            if (((SavePromptAction)((Object)object)).isCancelled()) {
                return;
            }
        }
        object = new Shell();
        FileDialog fileDialog = new FileDialog((Shell)object, 4096);
        if (this.lastDir == null && this.window.getKenyaFile() != null) {
            this.lastDir = this.window.getKenyaFile().getDir();
            if (this.lastDir.length() == 0) {
                this.lastDir = null;
            }
        }
        if (this.lastDir != null) {
            fileDialog.setFilterPath(this.lastDir);
        }
        fileDialog.setFilterExtensions(new String[]{"*.k"});
        fileDialog.setText("Open Kenya file");
        if (fileDialog.open() != null) {
            this.lastDir = fileDialog.getFilterPath();
            File file = new File(fileDialog.getFilterPath(), fileDialog.getFileName());
            FileLoaderSaver fileLoaderSaver = new FileLoaderSaver();
            fileLoaderSaver.setPath(file.getAbsolutePath());
            this.window.setKenyaFile(fileLoaderSaver);
            this.window.loadFromKenyaFile();
        }
    }
}

