/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.core;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kenya.FileLoaderSaver;
import kenya.errors.KenyaInternalError;
import kenya.sole.ui.action.AboutAction;
import kenya.sole.ui.action.FormatAction;
import kenya.sole.ui.action.SwitchAction;
import kenya.sole.ui.action.UniqueCheckedManager;
import kenya.sole.ui.action.file.CloseAction;
import kenya.sole.ui.action.file.ExitAction;
import kenya.sole.ui.action.file.JavaSaveAction;
import kenya.sole.ui.action.file.JavaSaveAsAction;
import kenya.sole.ui.action.file.KenyaSaveAction;
import kenya.sole.ui.action.file.KenyaSaveAsAction;
import kenya.sole.ui.action.file.NewAction;
import kenya.sole.ui.action.file.OpenAction;
import kenya.sole.ui.action.file.OpenInNewAction;
import kenya.sole.ui.action.file.SavePromptAction;
import kenya.sole.ui.action.fontchange.EditorBigFontAction;
import kenya.sole.ui.action.fontchange.EditorFixedFontAction;
import kenya.sole.ui.action.fontchange.EditorHugeFontAction;
import kenya.sole.ui.action.fontchange.EditorMediumFontAction;
import kenya.sole.ui.action.fontchange.EditorProportionalFontAction;
import kenya.sole.ui.action.fontchange.EditorSmallFontAction;
import kenya.sole.ui.action.fontchange.FontChangeAction;
import kenya.sole.ui.action.fontchange.IOBigFontAction;
import kenya.sole.ui.action.fontchange.IOFixedFontAction;
import kenya.sole.ui.action.fontchange.IOHugeFontAction;
import kenya.sole.ui.action.fontchange.IOMediumFontAction;
import kenya.sole.ui.action.fontchange.IOProportionalFontAction;
import kenya.sole.ui.action.fontchange.IOSmallFontAction;
import kenya.sole.ui.core.EditingWindowSwitchTarget;
import kenya.sole.ui.core.KenyaUI;
import kenya.sole.ui.editor.EditorPart;
import kenya.sole.ui.editor.EditorPartsFontTarget;
import kenya.sole.ui.editor.InterpreterPart;
import kenya.sole.ui.editor.JavaPart;
import kenya.sole.ui.editor.KenyaMediatorInput;
import kenya.sole.ui.editor.KenyaPart;
import kenya.sole.ui.editor.kenya.KenyaHelperThread;
import kenya.sole.ui.event.IModificationListener;
import kenya.sole.ui.event.ModificationEvent;
import kenya.sole.ui.event.TabSelectionAdapter;
import kenya.sole.ui.icons.ButtonManager;
import kenya.sole.ui.util.IHighlightingManager;
import kenya.ui.IButtonManager;
import mediator.IJavaCode;
import mediator.subscription.ICheckedCodeReceiver;
import mediator.subscription.IJavaCodeReceiver;
import mediator.subscription.ISubscriber;
import mediator.subscription.ISubscription;
import mediator.subscription.ISubscriptionData;
import mediator.subscription.MediationService;
import mediator.subscription.MediationSubscription;
import mediator.subscription.MediationTerms;
import mediator.subscription.MediatorInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

public class EditingWindow
extends ApplicationWindow
implements ISubscriber,
IModificationListener {
    public static final int KENYATABINDEX = 0;
    public static final int JAVATABINDEX = 1;
    public static final int INTERPRETERTABINDEX = 2;
    private final Runnable runIsVisible = new Runnable(){

        public void run() {
            EditingWindow.this.isVisible();
        }
    };
    private final Runnable runCloseWindow = new Runnable(){

        public void run() {
            EditingWindow.this.closeWindow();
        }
    };
    private final Object secondaryLock = new Object();
    private volatile IButtonManager buttonManager = null;
    private volatile TabFolder topTabs = null;
    private volatile SelectionListener tabSelectionListener = null;
    private volatile boolean isVisible = false;
    private volatile IAction javaSaveAction = null;
    private volatile IAction javaSaveAsAction = null;
    private volatile IHighlightingManager highlights = null;
    public static volatile String lastDir = null;
    private static final String file_menu_id = "file_menu";
    private static final String edit_menu_id = "edit_menu";
    private String subscriptionID;
    private static int counter = 0;

    public EditingWindow() {
        super(null);
        this.addStatusLine();
        this.addMenuBar();
    }

    protected synchronized Control createContents(Composite composite) {
        this.getShell().setText("Kenya IDE");
        this.buttonManager = new ButtonManager();
        this.topTabs = new TabFolder(composite, 0);
        TabItem tabItem = new TabItem(this.topTabs, 0);
        tabItem.setText("&Kenya");
        TabItem tabItem2 = new TabItem(this.topTabs, 0);
        tabItem2.setText("&Java");
        TabItem tabItem3 = new TabItem(this.topTabs, 0);
        tabItem3.setText("&Debugger");
        int n = 2560;
        KenyaPart kenyaPart = new KenyaPart((Composite)this.topTabs, n, (IStatusLineManager)this.getStatusLineManager(), this.buttonManager);
        kenyaPart.init();
        tabItem.setControl((Control)kenyaPart);
        kenyaPart.addModificationListener(this);
        JavaPart javaPart = new JavaPart((Composite)this.topTabs, n, (IStatusLineManager)this.getStatusLineManager(), this.buttonManager, EditingWindow.getNextClassName());
        javaPart.init();
        tabItem2.setControl((Control)javaPart);
        InterpreterPart interpreterPart = new InterpreterPart((Composite)this.topTabs, n, (IStatusLineManager)this.getStatusLineManager(), this.buttonManager);
        interpreterPart.init();
        tabItem3.setControl((Control)interpreterPart);
        final StyledText styledText = kenyaPart.getEditorTextWidget();
        interpreterPart.getEditorTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character >= ' ') {
                    int n = styledText.getCaretOffset();
                    EditingWindow.this.topTabs.setSelection(0);
                    styledText.setSelection(n);
                    styledText.showSelection();
                    styledText.insert("" + keyEvent.character);
                    styledText.setCaretOffset(n + 1);
                    styledText.setFocus();
                }
            }
        });
        this.tabSelectionListener = new TabSelectionAdapter(kenyaPart, javaPart, interpreterPart);
        this.topTabs.addSelectionListener(this.tabSelectionListener);
        FontData fontData = javaPart.getFont().getFontData()[0];
        fontData.setName("courier");
        fontData.setHeight(12);
        Font font = new Font((Device)this.topTabs.getDisplay(), fontData);
        javaPart.setSecondaryFont(font);
        interpreterPart.setSecondaryFont(font);
        fontData = javaPart.getFont().getFontData()[0];
        fontData.setName("arial");
        fontData.setHeight(12);
        Font font2 = new Font((Device)this.topTabs.getDisplay(), fontData);
        kenyaPart.setFont(font2);
        javaPart.setFont(font2);
        interpreterPart.setFont(font2);
        composite.setSize(600, 800);
        MediationTerms mediationTerms = new MediationTerms((MediatorInput)new KenyaMediatorInput(kenyaPart), (ICheckedCodeReceiver)kenyaPart, (IJavaCodeReceiver)javaPart);
        MediationSubscription mediationSubscription = new MediationSubscription((ISubscriber)this, mediationTerms);
        this.subscriptionID = MediationService.getInstance().addSubscription((ISubscription)mediationSubscription);
        JobDispatch.enqueueJob((AbstractJob)new KenyaHelperThread((KenyaPart)this.getEditor(0), (JavaPart)this.getEditor(1), this.subscriptionID));
        this.setupMenuManager();
        return this.topTabs;
    }

    public void subscriptionUpdate(ISubscriptionData iSubscriptionData) {
        try {
            if (iSubscriptionData == null || iSubscriptionData.getContents() == null) {
                throw new RuntimeException("mediator subscription terms violation:\nservice update is null");
            }
            Object[] objectArray = iSubscriptionData.getContents();
            switch (objectArray.length) {
                case 1: {
                    Exception exception = (Exception)objectArray[0];
                    exception.printStackTrace();
                    throw exception;
                }
                case 2: {
                    IJavaCode iJavaCode = (IJavaCode)objectArray[1];
                    if (iJavaCode == null) {
                        this.javaSaveAction.setEnabled(false);
                        this.javaSaveAsAction.setEnabled(false);
                        if (this.getTopTabs().isDisposed()) {
                            return;
                        }
                        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
                            if (this.getTopTabs().getSelectionIndex() != 0) {
                                this.switchToTab(0);
                            }
                        } else {
                            this.getTopTabs().getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    EditingWindow.this.switchToTab(0);
                                }
                            });
                        }
                    } else {
                        this.javaSaveAction.setEnabled(true);
                        this.javaSaveAsAction.setEnabled(true);
                    }
                    this.safeRedraw();
                    break;
                }
                default: {
                    throw new RuntimeException("mediator subscription terms violation:\nservice update contents are invalid");
                }
            }
        }
        catch (Exception exception) {
            throw new KenyaInternalError("The Kenya<->Java Mediator has reached an error state.\nThe details are as follows:\n" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeRedraw() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.getTopTabs().redraw();
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.safeRedraw();
                }
            });
        }
    }

    protected void handleShellCloseEvent() {
        this.closeWindow();
    }

    private static synchronized String getNextClassName() {
        return "Class" + ++counter;
    }

    protected synchronized void setupMenuManager() {
        MenuManager menuManager = this.getMenuBarManager();
        MenuManager menuManager2 = new MenuManager("&File");
        menuManager.add((IContributionItem)menuManager2);
        KenyaPart kenyaPart = (KenyaPart)this.getEditor(0);
        menuManager2.add((IAction)new NewAction(this));
        menuManager2.add((IAction)new OpenAction(kenyaPart));
        menuManager2.add((IAction)new OpenInNewAction(kenyaPart));
        menuManager2.add((IAction)new KenyaSaveAction(kenyaPart));
        menuManager2.add((IAction)new KenyaSaveAsAction(kenyaPart));
        JavaPart javaPart = (JavaPart)this.getEditor(1);
        this.javaSaveAction = new JavaSaveAction(javaPart);
        this.javaSaveAsAction = new JavaSaveAsAction(javaPart);
        this.javaSaveAction.setEnabled(false);
        this.javaSaveAsAction.setEnabled(false);
        menuManager2.add(this.javaSaveAction);
        menuManager2.add(this.javaSaveAsAction);
        menuManager2.add((IAction)new CloseAction(this));
        menuManager2.add((IAction)new ExitAction(this));
        MenuManager menuManager3 = new MenuManager("&Edit");
        menuManager.add((IContributionItem)menuManager3);
        menuManager3.add((IAction)new FormatAction(kenyaPart));
        MenuManager menuManager4 = new MenuManager("&View");
        menuManager.add((IContributionItem)menuManager4);
        MenuManager menuManager5 = new MenuManager("&Editor Fonts");
        menuManager4.add((IContributionItem)menuManager5);
        MenuManager menuManager6 = new MenuManager("Size");
        menuManager5.add((IContributionItem)menuManager6);
        UniqueCheckedManager uniqueCheckedManager = new UniqueCheckedManager();
        EditorPart[] editorPartArray = new EditorPart[]{kenyaPart, javaPart, this.getEditor(2)};
        EditorPartsFontTarget editorPartsFontTarget = new EditorPartsFontTarget(editorPartArray);
        FontChangeAction fontChangeAction = new EditorSmallFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager6.add((IAction)fontChangeAction);
        fontChangeAction = new EditorMediumFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager6.add((IAction)fontChangeAction);
        fontChangeAction = new EditorBigFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager6.add((IAction)fontChangeAction);
        fontChangeAction = new EditorHugeFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager6.add((IAction)fontChangeAction);
        MenuManager menuManager7 = new MenuManager("Type");
        menuManager5.add((IContributionItem)menuManager7);
        uniqueCheckedManager = new UniqueCheckedManager();
        fontChangeAction = new EditorProportionalFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager7.add((IAction)fontChangeAction);
        fontChangeAction = new EditorFixedFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager7.add((IAction)fontChangeAction);
        MenuManager menuManager8 = new MenuManager("&I/O Fonts");
        menuManager4.add((IContributionItem)menuManager8);
        MenuManager menuManager9 = new MenuManager("Size");
        menuManager8.add((IContributionItem)menuManager9);
        uniqueCheckedManager = new UniqueCheckedManager();
        fontChangeAction = new IOSmallFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager9.add((IAction)fontChangeAction);
        fontChangeAction = new IOMediumFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager9.add((IAction)fontChangeAction);
        fontChangeAction = new IOBigFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager9.add((IAction)fontChangeAction);
        fontChangeAction = new IOHugeFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager9.add((IAction)fontChangeAction);
        MenuManager menuManager10 = new MenuManager("Type");
        menuManager8.add((IContributionItem)menuManager10);
        uniqueCheckedManager = new UniqueCheckedManager();
        fontChangeAction = new IOProportionalFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager10.add((IAction)fontChangeAction);
        fontChangeAction = new IOFixedFontAction(editorPartsFontTarget);
        uniqueCheckedManager.addAction((IAction)fontChangeAction);
        menuManager10.add((IAction)fontChangeAction);
        EditingWindowSwitchTarget editingWindowSwitchTarget = new EditingWindowSwitchTarget(this);
        SwitchAction switchAction = new SwitchAction(editingWindowSwitchTarget, 0);
        switchAction.setText("Switch to &Kenya@Ctrl+K");
        switchAction.setToolTipText("View Kenya code");
        menuManager4.add((IAction)switchAction);
        switchAction = new SwitchAction(editingWindowSwitchTarget, 1);
        switchAction.setText("Switch to &Java@Ctrl+J");
        switchAction.setToolTipText("View Java translation");
        menuManager4.add((IAction)switchAction);
        switchAction = new SwitchAction(editingWindowSwitchTarget, 2);
        switchAction.setText("Switch to &Debugger@Ctrl+D");
        switchAction.setToolTipText("View Debugger");
        menuManager4.add((IAction)switchAction);
        MenuManager menuManager11 = new MenuManager("&Help");
        menuManager.add((IContributionItem)menuManager11);
        menuManager11.add((IAction)new AboutAction());
        menuManager.updateAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWindowVisible(boolean bl) {
        Object object = this.secondaryLock;
        synchronized (object) {
            this.isVisible = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getWindowVisible() {
        Object object = this.secondaryLock;
        synchronized (object) {
            return this.isVisible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        TabFolder tabFolder = this.getTopTabs();
        if (tabFolder == null || tabFolder.isDisposed() || KenyaUI.isExiting()) {
            return false;
        }
        if (Thread.currentThread().equals(tabFolder.getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.setWindowVisible(tabFolder.isVisible());
            }
        } else {
            tabFolder.getDisplay().syncExec(this.runIsVisible);
        }
        return this.getWindowVisible();
    }

    public synchronized TabFolder getTopTabs() {
        return this.topTabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWindow() {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                if (this.unloadKenyaFile()) {
                    this.close();
                    MediationService.getInstance().cancelSubscription(this.subscriptionID);
                }
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(this.runCloseWindow);
        }
    }

    public boolean unloadKenyaFile() {
        if (this.getEditor(0).isModified()) {
            SavePromptAction savePromptAction = new SavePromptAction((KenyaPart)this.getEditor(0));
            savePromptAction.run();
            if (savePromptAction.isCancelled()) {
                return false;
            }
        }
        return true;
    }

    public synchronized IButtonManager getButtonManager() {
        return this.buttonManager;
    }

    public synchronized SelectionListener getTabSelectionListener() {
        return this.tabSelectionListener;
    }

    public synchronized EditorPart getEditor(int n) {
        return (EditorPart)this.topTabs.getItem(n).getControl();
    }

    public synchronized void switchToTab(int n) {
        if ((n == 0 || n == 1 || n == 2) && this.topTabs != null && this.getTopTabs().getSelectionIndex() != n) {
            this.getTopTabs().setSelection(n);
            Event event = new Event();
            event.widget = this.topTabs;
            event.item = this.getEditor(n);
            this.tabSelectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    public static String[] parseIntoArgs(String string) {
        Pattern pattern = Pattern.compile("[ ]*([^ ]+)[ ]*");
        Matcher matcher = pattern.matcher(string);
        matcher.reset();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeSetStatus(final String string) {
        if (Thread.currentThread().equals(this.getTopTabs().getDisplay().getThread())) {
            EditingWindow editingWindow = this;
            synchronized (editingWindow) {
                this.setStatus(string);
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getTopTabs().getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditingWindow.this.safeSetStatus(string);
                }
            });
        }
    }

    public void objectModified(ModificationEvent modificationEvent) {
        if (modificationEvent.source != null && modificationEvent.source.equals(this.getEditor(0))) {
            KenyaPart kenyaPart = (KenyaPart)modificationEvent.source;
            boolean bl = modificationEvent.modified;
            FileLoaderSaver fileLoaderSaver = kenyaPart.getKenyaFile();
            if (!kenyaPart.isModified() && bl) {
                if (fileLoaderSaver != null && fileLoaderSaver.getPath() != null && !fileLoaderSaver.getPath().equals("")) {
                    this.getShell().setText("Kenya IDE: " + fileLoaderSaver.getPath() + " (modified)");
                } else {
                    this.getShell().setText("Kenya IDE (modified)");
                }
            } else if (kenyaPart.isModified() && !bl) {
                if (fileLoaderSaver != null && fileLoaderSaver.getPath() != null && !fileLoaderSaver.getPath().equals("")) {
                    this.getShell().setText("Kenya IDE: " + fileLoaderSaver.getPath());
                } else {
                    this.getShell().setText("Kenya IDE");
                }
            }
        }
    }

    public void objectAboutToBeModified(ModificationEvent modificationEvent) {
        KenyaPart kenyaPart;
        if (!(modificationEvent.source instanceof KenyaPart) || (kenyaPart = (KenyaPart)modificationEvent.source) == null || !kenyaPart.equals(this.getEditor(0)) || kenyaPart.getKenyaFile() == null || kenyaPart.getKenyaFile().equals(modificationEvent.details)) {
            // empty if block
        }
    }
}

