/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kenya.FileLoaderSaver;
import kenya.sole.ui.core.EditingWindow;
import kenya.sole.ui.core.KenyaUI;
import kenya.sole.ui.editor.KenyaPart;
import kenya.sole.ui.event.ExitListener;
import org.eclipse.swt.widgets.Display;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.IJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

public class EditingWindowUtilsFactory {
    private static final Set editingWindows = new HashSet();

    private EditingWindowUtilsFactory() {
    }

    public static EditingWindow createAndOpenEditorWindow() {
        EditingWindow editingWindow = new EditingWindow();
        EditingWindowUtilsFactory.openEditorWindow(editingWindow);
        return editingWindow;
    }

    public static EditingWindow createAndOpenEditorWindow(FileLoaderSaver fileLoaderSaver) {
        EditingWindow editingWindow = new EditingWindow();
        KenyaPart kenyaPart = (KenyaPart)editingWindow.getEditor(0);
        kenyaPart.setKenyaFile(fileLoaderSaver);
        kenyaPart.loadFromKenyaFile();
        EditingWindowUtilsFactory.openEditorWindow(editingWindow);
        return editingWindow;
    }

    private static void openEditorWindow(final EditingWindow editingWindow) {
        final Runnable runnable = new Runnable(){

            public void run() {
                ExitListener exitListener = new ExitListener(editingWindow);
                KenyaUI.addExitListener((IJob)exitListener);
                editingWindow.setBlockOnOpen(true);
                EditingWindowUtilsFactory.windowOpened(editingWindow);
                editingWindow.open();
                EditingWindowUtilsFactory.windowClosed(editingWindow);
                KenyaUI.removeExitListener(exitListener);
            }
        };
        AbstractJob abstractJob = new AbstractJob(){

            public void execute() {
                if (Display.getDefault().equals(Thread.currentThread())) {
                    runnable.run();
                } else {
                    Display.getDefault().syncExec(runnable);
                }
            }
        };
        JobDispatch.enqueueJob((AbstractJob)abstractJob);
    }

    private static synchronized void windowOpened(EditingWindow editingWindow) {
        editingWindows.add(editingWindow);
    }

    private static synchronized void windowClosed(EditingWindow editingWindow) {
        editingWindows.remove(editingWindow);
        if (editingWindows.size() == 0) {
            if (Display.getCurrent().isDisposed()) {
                Display.getCurrent().dispose();
            }
            KenyaUI.exit();
        }
    }

    public static synchronized void closeEditingWindows() {
        Iterator iterator = editingWindows.iterator();
        while (iterator.hasNext()) {
            EditingWindow editingWindow = (EditingWindow)iterator.next();
            editingWindow.closeWindow();
        }
    }
}

