/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import kenya.sole.ui.core.KenyaUI;
import kenya.sole.ui.editor.util.DefaultHighlightingManager;
import kenya.sole.ui.event.EditorControlListener;
import kenya.sole.ui.event.IModifiableObject;
import kenya.sole.ui.event.IModificationListener;
import kenya.sole.ui.event.ModificationEvent;
import kenya.sole.ui.event.NumbersSelectionListener;
import kenya.sole.ui.util.IHighlightingManager;
import kenya.ui.IButtonManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EditorPart
extends SashForm
implements ActionListener,
IModifiableObject {
    protected Object lock;
    protected LineStyleListener lineStyler = null;
    protected volatile StyledText lineNumbers = null;
    protected int lineNumberCount = -1;
    protected StringBuffer lineNumberBuffer;
    protected int caretOffset = 0;
    protected IHighlightingManager highlightingManager;
    protected IStatusLineManager statusLine;
    protected IButtonManager buttonManager;
    protected volatile String editorWidgetText = "";
    protected volatile StyledText editorText;
    protected boolean modified;
    private boolean isVisible;
    private final Runnable runIsVisible = new Runnable(){

        public void run() {
            EditorPart.this.isVisible();
        }
    };
    private final Runnable runGetEditorText = new Runnable(){

        public void run() {
            EditorPart.this.getEditorText();
        }
    };
    private final Runnable runGetCaretOffset = new Runnable(){

        public void run() {
            EditorPart.this.getCaretOffset();
        }
    };
    private ArrayList modListeners = new ArrayList();

    private EditorPart(Composite composite, int n) {
        super(composite, n);
        this.lock = new Object();
        this.lineNumberBuffer = new StringBuffer();
    }

    public EditorPart(Composite composite, int n, IStatusLineManager iStatusLineManager, IButtonManager iButtonManager) {
        this(composite, n);
        this.statusLine = iStatusLineManager;
        this.buttonManager = iButtonManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeSetStatus(final String string) {
        if (this.statusLine != null) {
            if (Thread.currentThread().equals(this.getDisplay().getThread())) {
                EditorPart editorPart = this;
                synchronized (editorPart) {
                    this.statusLine.setMessage(string);
                }
            } else {
                if (!this.isVisible()) {
                    return;
                }
                this.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        EditorPart.this.safeSetStatus(string);
                    }
                });
            }
        }
    }

    public void setLineStyler(LineStyleListener lineStyleListener) {
        if (this.editorText != null) {
            if (this.lineStyler != null) {
                this.editorText.removeLineStyleListener(this.lineStyler);
            }
            this.lineStyler = lineStyleListener;
            this.editorText.addLineStyleListener(this.lineStyler);
        }
    }

    public LineStyleListener getLineStyler() {
        return this.lineStyler;
    }

    public void init() {
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 256);
        this.buildLineNumbers(sashForm);
        this.buildEditorContent(sashForm);
        this.setModified(false);
        sashForm.setWeights(new int[]{1, 18});
        this.setWeights(new int[]{1});
        this.editorText.setFocus();
        sashForm.addControlListener((ControlListener)new EditorControlListener(sashForm, this.lineNumbers, this.editorText));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeRedraw() {
        if (Thread.currentThread().equals(this.getDisplay().getThread())) {
            EditorPart editorPart = this;
            synchronized (editorPart) {
                this.redraw();
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditorPart.this.safeRedraw();
                }
            });
        }
    }

    protected void buildLineNumbers(SashForm sashForm) {
        this.lineNumbers = new StyledText((Composite)sashForm, 524296);
        this.lineNumbers.setEditable(false);
        this.lineNumbers.setDoubleClickEnabled(false);
        this.lineNumbers.setEnabled(false);
        this.lineNumbers.addSelectionListener((SelectionListener)new NumbersSelectionListener(this.lineNumbers));
        this.lineNumbers.setBackground(DefaultHighlightingManager.WHITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildLineNumbers() {
        if (Thread.currentThread().equals(this.getDisplay().getThread())) {
            EditorPart editorPart = this;
            synchronized (editorPart) {
                if (this.lineNumberCount != this.editorText.getLineCount()) {
                    int n = this.lineNumbers.getTopPixel();
                    this.lineNumberBuffer.setLength(0);
                    for (int i = 1; i <= this.editorText.getLineCount(); ++i) {
                        this.lineNumberBuffer.append(i);
                        this.lineNumberBuffer.append('\r');
                    }
                    this.lineNumbers.setText(this.lineNumberBuffer.toString());
                    this.lineNumbers.setTopPixel(n);
                    this.lineNumberCount = this.editorText.getLineCount();
                }
            }
        } else if (this.isVisible()) {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    EditorPart.this.rebuildLineNumbers();
                }
            });
        }
    }

    public synchronized void positionLineNumbers() {
        if (this.lineNumbers.getTopPixel() != this.editorText.getTopPixel()) {
            this.lineNumbers.setTopPixel(this.editorText.getTopPixel());
            this.lineNumbers.redraw();
        }
    }

    protected void buildEditorContent(SashForm sashForm) {
        this.editorText = new StyledText((Composite)sashForm, 768);
    }

    public synchronized StyledText getLineNumberWidget() {
        return this.lineNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEditorWidgetText() {
        Object object = this.lock;
        synchronized (object) {
            return this.editorWidgetText;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEditorWidgetText(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.editorWidgetText = string;
        }
    }

    public synchronized StyledText getEditorTextWidget() {
        return this.editorText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEditorText() {
        if (!this.isVisible()) {
            return "";
        }
        if (Thread.currentThread().equals(this.editorText.getDisplay().getThread())) {
            EditorPart editorPart = this;
            synchronized (editorPart) {
                this.setEditorWidgetText(this.editorText.getText());
            }
        } else {
            this.editorText.getDisplay().syncExec(this.runGetEditorText);
        }
        return this.getEditorWidgetText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCaretOffsetInternal(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.caretOffset = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCaretOffsetInternal() {
        Object object = this.lock;
        synchronized (object) {
            return this.caretOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretOffset() {
        if (!this.isVisible()) {
            return 0;
        }
        if (Thread.currentThread().equals(this.editorText.getDisplay().getThread())) {
            EditorPart editorPart = this;
            synchronized (editorPart) {
                if (this.editorText.isDisposed()) {
                    this.setCaretOffsetInternal(0);
                } else {
                    this.setCaretOffsetInternal(this.editorText.getCaretOffset());
                }
            }
        } else {
            this.editorText.getDisplay().syncExec(this.runGetCaretOffset);
        }
        return this.getCaretOffsetInternal();
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public synchronized void setModified(boolean bl) {
        ModificationEvent modificationEvent = new ModificationEvent(this, this.getEditorTextWidget(), bl);
        this.fireEditorPreModified(modificationEvent);
        this.modified = bl;
        this.fireEditorPostModified(modificationEvent);
    }

    public void addModificationListener(IModificationListener iModificationListener) {
        this.modListeners.add(iModificationListener);
    }

    public void removeModificationListener(IModificationListener iModificationListener) {
        this.modListeners.remove(iModificationListener);
    }

    protected void fireEditorPostModified(ModificationEvent modificationEvent) {
        for (int i = 0; i < this.modListeners.size(); ++i) {
            ((IModificationListener)this.modListeners.get(i)).objectModified(modificationEvent);
        }
    }

    protected void fireEditorPreModified(ModificationEvent modificationEvent) {
        for (int i = 0; i < this.modListeners.size(); ++i) {
            ((IModificationListener)this.modListeners.get(i)).objectAboutToBeModified(modificationEvent);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.editorText != null) {
            this.editorText.setFont(font);
            this.lineNumbers.setFont(font);
        }
    }

    public void setSecondaryFont(Font font) {
    }

    public Font getSecondaryFont() {
        return null;
    }

    public synchronized IHighlightingManager getHighlightingManager() {
        return this.highlightingManager;
    }

    public synchronized void setHighlightingManager(IHighlightingManager iHighlightingManager) {
        this.highlightingManager = iHighlightingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWindowVisible(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.isVisible = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getWindowVisible() {
        Object object = this.lock;
        synchronized (object) {
            return this.isVisible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        if (this.editorText == null || this.editorText.isDisposed() || KenyaUI.isExiting()) {
            return false;
        }
        if (Thread.currentThread().equals(this.editorText.getDisplay().getThread())) {
            EditorPart editorPart = this;
            synchronized (editorPart) {
                this.setWindowVisible(this.getParent().isVisible());
            }
        } else {
            this.editorText.getDisplay().syncExec(this.runIsVisible);
        }
        return this.getWindowVisible();
    }

    public synchronized IButtonManager getButtonManager() {
        return this.buttonManager;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

