/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor;

import java.io.File;
import java.util.Date;
import java.util.List;
import kenya.FileLoaderSaver;
import kenya.sole.ui.core.EditingWindow;
import kenya.sole.ui.editor.EditorPart;
import kenya.sole.ui.editor.kenya.KenyaKeyListener;
import kenya.sole.ui.editor.kenya.KenyaPaintListener;
import kenya.sole.ui.editor.kenya.KenyaTableSelectionChangedListener;
import kenya.sole.ui.editor.kenya.KenyaTextChangedListener;
import kenya.sole.ui.editor.util.DefaultHighlightingManager;
import kenya.sole.ui.editor.util.HighlightingFactory;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.ui.IButtonManager;
import kenya.ui.errors.HumanErrorLabelProvider;
import kenya.ui.errors.JavacErrorLabelProvider;
import kenya.ui.errors.KenyaErrorContentProvider;
import kenya.ui.indentation.IndentationStrategy;
import kenya.ui.syntaxhighlighting.KenyaLineStyler;
import mediator.ICheckedCode;
import mediator.subscription.ICheckedCodeReceiver;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class KenyaPart
extends EditorPart
implements ICheckedCodeReceiver {
    protected volatile TableViewer kenyaHumanErrorTable;
    protected volatile TableViewer kenyaJavacErrorTable;
    protected IndentationStrategy indentationStrategy;
    protected KenyaErrorContentProvider kenyaTableContents;
    private final Date lastKeyEvent = new Date();
    private volatile boolean reparse = false;
    private volatile FileLoaderSaver kenyaFileLoaderSaver = null;
    private final Runnable runLoadFromKenyaFile = new Runnable(){

        public void run() {
            KenyaPart.this.loadFromKenyaFile();
        }
    };

    public KenyaPart(Composite composite, int n, IStatusLineManager iStatusLineManager, IButtonManager iButtonManager) {
        super(composite, n, iStatusLineManager, iButtonManager);
    }

    public void init() {
        super.init();
        this.setHighlightingManager(new DefaultHighlightingManager(this, HighlightingFactory.createErrorHighlighter(this), HighlightingFactory.createWarningHighlighter(this), HighlightingFactory.createLinkedLocationHighlighter(this)));
        this.indentationStrategy = new IndentationStrategy();
        this.kenyaTableContents = new KenyaErrorContentProvider();
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Kenya errors");
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText("Java errors");
        this.kenyaHumanErrorTable = new TableViewer((Composite)tabFolder, 68356);
        this.kenyaHumanErrorTable.setUseHashlookup(true);
        this.kenyaHumanErrorTable.setContentProvider((IContentProvider)this.kenyaTableContents);
        this.kenyaHumanErrorTable.setLabelProvider((IBaseLabelProvider)new HumanErrorLabelProvider(this.buttonManager, this.editorText.getLineDelimiter()));
        KenyaTableSelectionChangedListener kenyaTableSelectionChangedListener = new KenyaTableSelectionChangedListener(this);
        this.kenyaHumanErrorTable.addSelectionChangedListener((ISelectionChangedListener)kenyaTableSelectionChangedListener);
        this.kenyaHumanErrorTable.getTable().setLinesVisible(false);
        this.kenyaHumanErrorTable.getTable().setHeaderVisible(false);
        tabItem.setControl(this.kenyaHumanErrorTable.getControl());
        this.kenyaJavacErrorTable = new TableViewer((Composite)tabFolder, 68356);
        this.kenyaJavacErrorTable.setUseHashlookup(true);
        this.kenyaJavacErrorTable.setContentProvider((IContentProvider)this.kenyaTableContents);
        this.kenyaJavacErrorTable.setLabelProvider((IBaseLabelProvider)new JavacErrorLabelProvider(this.buttonManager, this.editorText.getLineDelimiter()));
        this.kenyaJavacErrorTable.addSelectionChangedListener((ISelectionChangedListener)kenyaTableSelectionChangedListener);
        this.kenyaJavacErrorTable.getTable().setLinesVisible(false);
        this.kenyaJavacErrorTable.getTable().setHeaderVisible(false);
        tabItem2.setControl(this.kenyaJavacErrorTable.getControl());
        this.setWeights(new int[]{3, 1});
    }

    protected void buildEditorContent(SashForm sashForm) {
        super.buildEditorContent(sashForm);
        this.setLineStyler((LineStyleListener)new KenyaLineStyler());
        this.editorText.addVerifyKeyListener((VerifyKeyListener)new KenyaKeyListener(this));
        this.editorText.addPaintListener((PaintListener)new KenyaPaintListener(this));
        this.editorText.getContent().addTextChangeListener((TextChangeListener)new KenyaTextChangedListener(this));
        if (this.highlightingManager != null) {
            this.editorText.addMouseListener(this.highlightingManager.createKenyaMouseListener(this));
            this.editorText.addLineBackgroundListener(this.highlightingManager.createKenyaLineBackgroundListener(this));
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.kenyaHumanErrorTable != null) {
            this.kenyaHumanErrorTable.getControl().setFont(font);
            this.kenyaJavacErrorTable.getControl().setFont(font);
        }
    }

    public synchronized void reparse(boolean bl) {
        this.reparse = bl;
    }

    public synchronized boolean reparse() {
        return this.reparse;
    }

    public IndentationStrategy getIndentationStrategy() {
        return this.indentationStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectInKenyaErrorTable(final ISourceCodeInformation iSourceCodeInformation) {
        if (!this.isVisible()) {
            return;
        }
        if (Thread.currentThread().equals(this.getDisplay().getThread())) {
            KenyaPart kenyaPart = this;
            synchronized (kenyaPart) {
                if (this.kenyaJavacErrorTable == null || this.kenyaHumanErrorTable == null) {
                    return;
                }
                if (iSourceCodeInformation == null && !this.isDisposed()) {
                    this.kenyaJavacErrorTable.getTable().deselectAll();
                    this.kenyaHumanErrorTable.getTable().deselectAll();
                } else {
                    int n = this.kenyaTableContents.getIndex(iSourceCodeInformation);
                    if (n == -1) {
                        this.kenyaJavacErrorTable.getTable().deselectAll();
                        this.kenyaHumanErrorTable.getTable().deselectAll();
                    } else {
                        this.kenyaJavacErrorTable.getTable().setSelection(n);
                        this.kenyaJavacErrorTable.getTable().showSelection();
                        this.kenyaHumanErrorTable.getTable().setSelection(n);
                        this.kenyaHumanErrorTable.getTable().showSelection();
                    }
                }
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    KenyaPart.this.selectInKenyaErrorTable(iSourceCodeInformation);
                }
            });
        }
    }

    public synchronized void resetTimer() {
        this.lastKeyEvent.setTime(System.currentTimeMillis());
    }

    public synchronized Date getLastKeyEvent() {
        return this.lastKeyEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckedCode(final ICheckedCode iCheckedCode) {
        this.getHighlightingManager().clear();
        if (!this.isDisposed() && Thread.currentThread().equals(this.getDisplay().getThread())) {
            KenyaPart kenyaPart = this;
            synchronized (kenyaPart) {
                this.kenyaHumanErrorTable.setInput((Object)iCheckedCode);
                this.kenyaJavacErrorTable.setInput((Object)iCheckedCode);
                List list = iCheckedCode.getInfos();
                if (iCheckedCode.isErroredCode()) {
                    List list2 = iCheckedCode.getErrors();
                    for (int i = 0; i < list2.size(); ++i) {
                        ISourceCodeError iSourceCodeError = (ISourceCodeError)list2.get(i);
                        this.getHighlightingManager().addSourceCodeError(iSourceCodeError);
                    }
                    if (list2.size() == 1) {
                        this.safeSetStatus("1 error found.");
                    } else {
                        this.safeSetStatus("" + list2.size() + " errors found.");
                    }
                } else if (list.size() == 0) {
                    this.safeSetStatus("No errors or warnings found.");
                } else if (list.size() == 1) {
                    this.safeSetStatus("1 warning found; no errors found.");
                } else {
                    this.safeSetStatus("" + list.size() + " warnings found; no errors found.");
                }
                for (int i = 0; i < list.size(); ++i) {
                    ISourceCodeInformation iSourceCodeInformation = (ISourceCodeInformation)list.get(i);
                    this.getHighlightingManager().addSourceCodeWarning(iSourceCodeInformation);
                }
                ((KenyaLineStyler)this.getLineStyler()).parseBlockComments(this.getEditorTextWidget().getContent());
                this.getEditorTextWidget().redraw();
            }
        } else {
            if (!this.isVisible()) {
                return;
            }
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    KenyaPart.this.setCheckedCode(iCheckedCode);
                }
            });
        }
    }

    public synchronized void setKenyaFile(FileLoaderSaver fileLoaderSaver) {
        this.kenyaFileLoaderSaver = fileLoaderSaver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromKenyaFile() {
        if (this.editorText != null && this.getKenyaFile() != null) {
            if (Thread.currentThread().equals(this.editorText.getDisplay().getThread())) {
                KenyaPart kenyaPart = this;
                synchronized (kenyaPart) {
                    FileLoaderSaver fileLoaderSaver = this.getKenyaFile();
                    String string = fileLoaderSaver.loadFile(fileLoaderSaver.getPath());
                    this.editorText.setText(string);
                    this.getIndentationStrategy().parseText(this.editorText);
                    this.editorText.setCaretOffset(0);
                    this.editorText.setSelection(0);
                    this.editorText.setFocus();
                    this.reparse(true);
                    this.setModified(false);
                }
            } else {
                this.editorText.getDisplay().syncExec(this.runLoadFromKenyaFile);
            }
        }
    }

    public synchronized FileLoaderSaver getKenyaFile() {
        return this.kenyaFileLoaderSaver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKenyaAs(final boolean bl) {
        if (Thread.currentThread().equals(this.getDisplay().getThread())) {
            KenyaPart kenyaPart = this;
            synchronized (kenyaPart) {
                Shell shell = new Shell();
                FileDialog fileDialog = new FileDialog(shell, 8192);
                fileDialog.setFilterExtensions(new String[]{"*.k"});
                fileDialog.setText("Save Kenya file");
                String string = EditingWindow.lastDir;
                if (string == null && this.getKenyaFile() != null && (string = this.getKenyaFile().getDir()).length() == 0) {
                    string = null;
                }
                if (string != null) {
                    fileDialog.setFilterPath(string);
                }
                if (fileDialog.open() != null) {
                    string = fileDialog.getFilterPath();
                    File file = new File(fileDialog.getFilterPath(), fileDialog.getFileName());
                    if (this.getKenyaFile() == null) {
                        FileLoaderSaver fileLoaderSaver = new FileLoaderSaver();
                        fileLoaderSaver.setPath(file.getAbsolutePath());
                        this.setKenyaFile(fileLoaderSaver);
                    } else {
                        FileLoaderSaver fileLoaderSaver = this.getKenyaFile();
                        fileLoaderSaver.setPath(file.getAbsolutePath());
                    }
                    this.saveKenya(bl);
                }
            }
        } else {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    KenyaPart.this.saveKenyaAs(bl);
                }
            });
        }
    }

    public void saveKenya(boolean bl) {
        System.err.println("save disabled!");
    }
}

