/*
 * Decompiled with CFR 0.152.
 */
package kenya.sole.ui.editor.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kenya.sole.ui.editor.EditorPart;
import kenya.sole.ui.editor.KenyaPart;
import kenya.sole.ui.editor.util.ErrorHighlighter;
import kenya.sole.ui.editor.util.LinkedLocationHighlighter;
import kenya.sole.ui.editor.util.WarningHighlighter;
import kenya.sole.ui.util.AbstractHighlighter;
import kenya.sole.ui.util.IHighlightingManager;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class DefaultHighlightingManager
implements IHighlightingManager {
    public static final Color WHITE = new Color((Device)Display.getDefault(), 255, 244, 212);
    private final KenyaPart editor;
    private final ErrorHighlighter errorH;
    private final WarningHighlighter warningH;
    private final LinkedLocationHighlighter linkedLocationH;
    private final Map pointsToErrors = new HashMap();
    private final Map pointsToWarnings = new HashMap();

    public DefaultHighlightingManager(KenyaPart kenyaPart, ErrorHighlighter errorHighlighter, WarningHighlighter warningHighlighter, LinkedLocationHighlighter linkedLocationHighlighter) {
        this.editor = kenyaPart;
        this.errorH = errorHighlighter;
        this.warningH = warningHighlighter;
        this.linkedLocationH = linkedLocationHighlighter;
    }

    public ErrorHighlighter getErrorHighlighter() {
        return this.errorH;
    }

    public WarningHighlighter getWarningHighlighter() {
        return this.warningH;
    }

    public LinkedLocationHighlighter getLinkedLocationHighlighter() {
        return this.linkedLocationH;
    }

    public void paint(PaintEvent paintEvent) {
        this.errorH.paintControl(paintEvent);
        this.warningH.paintControl(paintEvent);
        this.linkedLocationH.paintControl(paintEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DefaultHighlightingManager defaultHighlightingManager = this;
        synchronized (defaultHighlightingManager) {
            this.errorH.clearHighlights();
            this.warningH.clearHighlights();
            this.linkedLocationH.clearHighlights();
            this.pointsToErrors.clear();
            this.pointsToWarnings.clear();
        }
        this.editor.selectInKenyaErrorTable(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceCodeError(final ISourceCodeError iSourceCodeError) {
        if (!this.editor.isVisible()) {
            return;
        }
        StyledText styledText = this.editor.getEditorTextWidget();
        if (Thread.currentThread().equals(styledText.getDisplay().getThread())) {
            DefaultHighlightingManager defaultHighlightingManager = this;
            synchronized (defaultHighlightingManager) {
                ISourceCodeLocation iSourceCodeLocation = iSourceCodeError.getLocation();
                int n = iSourceCodeLocation.getLineNumber() - 1;
                int n2 = iSourceCodeLocation.getColumnNumber() - 1;
                int n3 = iSourceCodeLocation.getTokenLength();
                if (!this.editor.isVisible() || styledText.isDisposed()) {
                    return;
                }
                int n4 = n;
                if (n4 < styledText.getContent().getLineCount() && n4 >= 0) {
                    int n5 = styledText.getOffsetAtLine(n4) + n2;
                    this.errorH.addHighlight(n5, n3, n);
                    Point point = new Point(n5, n5 + n3);
                    this.registerError(point, iSourceCodeError);
                }
            }
        } else {
            styledText.getDisplay().syncExec(new Runnable(){

                public void run() {
                    DefaultHighlightingManager.this.addSourceCodeError(iSourceCodeError);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceCodeWarning(final ISourceCodeInformation iSourceCodeInformation) {
        if (!this.editor.isVisible()) {
            return;
        }
        StyledText styledText = this.editor.getEditorTextWidget();
        if (Thread.currentThread().equals(styledText.getDisplay().getThread())) {
            DefaultHighlightingManager defaultHighlightingManager = this;
            synchronized (defaultHighlightingManager) {
                ISourceCodeLocation iSourceCodeLocation = iSourceCodeInformation.getLocation();
                int n = iSourceCodeLocation.getLineNumber() - 1;
                int n2 = iSourceCodeLocation.getColumnNumber() - 1;
                int n3 = iSourceCodeLocation.getTokenLength();
                if (!this.editor.isVisible() || styledText.isDisposed()) {
                    return;
                }
                int n4 = n;
                if (n4 >= styledText.getLineCount()) {
                    n4 = styledText.getLineCount() - 1;
                }
                int n5 = styledText.getOffsetAtLine(n4) + n2;
                this.warningH.addHighlight(n5, n3, n);
                Point point = new Point(n5, n5 + n3);
                this.registerWarning(point, iSourceCodeInformation);
            }
        } else {
            styledText.getDisplay().syncExec(new Runnable(){

                public void run() {
                    DefaultHighlightingManager.this.addSourceCodeWarning(iSourceCodeInformation);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlight(final ISourceCodeLocation iSourceCodeLocation, final AbstractHighlighter abstractHighlighter) {
        if (!this.editor.isVisible()) {
            return;
        }
        StyledText styledText = this.editor.getEditorTextWidget();
        if (Thread.currentThread().equals(styledText.getDisplay().getThread())) {
            DefaultHighlightingManager defaultHighlightingManager = this;
            synchronized (defaultHighlightingManager) {
                int n = iSourceCodeLocation.getLineNumber() - 1;
                int n2 = iSourceCodeLocation.getColumnNumber() - 1;
                int n3 = iSourceCodeLocation.getTokenLength();
                if (!this.editor.isVisible() || styledText.isDisposed()) {
                    return;
                }
                int n4 = n;
                if (n4 >= styledText.getLineCount()) {
                    n4 = styledText.getLineCount() - 1;
                }
                int n5 = styledText.getOffsetAtLine(n4) + n2;
                abstractHighlighter.addHighlight(n5, n3, n4);
            }
        } else {
            styledText.getDisplay().syncExec(new Runnable(){

                public void run() {
                    DefaultHighlightingManager.this.addHighlight(iSourceCodeLocation, abstractHighlighter);
                }
            });
        }
    }

    public MouseListener createKenyaMouseListener(final EditorPart editorPart) {
        MouseListener mouseListener = new MouseListener(){

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (mouseEvent.button == 1) {
                    int n = editorPart.getEditorTextWidget().getCaretOffset();
                    DefaultHighlightingManager.this.showLinkedHighlights(n);
                }
            }
        };
        return mouseListener;
    }

    public void showLinkedHighlights(int n) {
        ISourceCodeInformation iSourceCodeInformation = this.searchForErrorOrWarning(n);
        if (iSourceCodeInformation != null) {
            this.linkedLocationH.clearHighlights();
            ISourceCodeLocation[] iSourceCodeLocationArray = iSourceCodeInformation.getLinkedInformation();
            if (iSourceCodeLocationArray != null) {
                for (int i = 0; i < iSourceCodeLocationArray.length; ++i) {
                    this.addHighlight(iSourceCodeLocationArray[i], this.linkedLocationH);
                }
            }
            this.editor.selectInKenyaErrorTable(iSourceCodeInformation);
            this.editor.safeRedraw();
        }
    }

    private synchronized void registerError(Point point, ISourceCodeError iSourceCodeError) {
        this.pointsToErrors.put(point, iSourceCodeError);
    }

    private synchronized void registerWarning(Point point, ISourceCodeInformation iSourceCodeInformation) {
        this.pointsToWarnings.put(point, iSourceCodeInformation);
    }

    private synchronized ISourceCodeInformation searchForErrorOrWarning(int n) {
        Point point;
        Iterator iterator = this.pointsToErrors.keySet().iterator();
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            if (point.x >= n || point.y < n) continue;
            return (ISourceCodeInformation)this.pointsToErrors.get(point);
        }
        iterator = this.pointsToWarnings.keySet().iterator();
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            if (point.x >= n || point.y < n) continue;
            return (ISourceCodeInformation)this.pointsToWarnings.get(point);
        }
        return null;
    }

    public LineBackgroundListener createKenyaLineBackgroundListener(final EditorPart editorPart) {
        return new LineBackgroundListener(){

            public void lineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
                int n = editorPart.getLineNumberWidget().getLineAtOffset(lineBackgroundEvent.lineOffset);
                lineBackgroundEvent.lineBackground = DefaultHighlightingManager.this.errorH.isHighlightOnLine(n) ? DefaultHighlightingManager.this.errorH.getBackgroundColor() : (DefaultHighlightingManager.this.warningH.isHighlightOnLine(n) ? DefaultHighlightingManager.this.warningH.getBackgroundColor() : (DefaultHighlightingManager.this.linkedLocationH.isHighlightOnLine(n) ? DefaultHighlightingManager.this.linkedLocationH.getBackgroundColor() : WHITE));
            }
        };
    }
}

