/*
 * Created on 30-Oct-2004
 */
package kenya.sole.ui.action;


import org.eclipse.jface.resource.ImageDescriptor;

/**
 * @author Thomas Timbul
 */
public class SwitchAction extends TargetAction {
	
	protected int switchto;
	
	/**
	 * @param target
	 */
	public SwitchAction(ISwitchActionTarget target, int switchto) {
		super(target);
		this.switchto = switchto;
	}
	/**
	 * @param target
	 * @param text
	 */
	public SwitchAction(ISwitchActionTarget target, int switchto, String text) {
		super(target, text);
		this.switchto = switchto;
	}
	/**
	 * @param target
	 * @param text
	 * @param image
	 */
	public SwitchAction(ISwitchActionTarget target, int switchto, String text, ImageDescriptor image) {
		super(target, text, image);
		this.switchto = switchto;
	}
	/**
	 * @param target
	 * @param text
	 * @param style
	 */
	public SwitchAction(ISwitchActionTarget target, int switchto, String text, int style) {
		super(target, text, style);
		this.switchto = switchto;
	}
	
	public void run() {
		((ISwitchActionTarget)target).switchTo(switchto);
	}
}
