/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Jul 28, 2004
 *
 */
package kenya.sole.ui.action.file;

import java.io.File;

import kenya.FileLoaderSaver;
import kenya.sole.ui.editor.KenyaPart;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class OpenAction extends Action {

    private final KenyaPart window;

    private String lastDir = null;

    public OpenAction(KenyaPart w) {
        window = w;
        setText("&Open in this window...@Ctrl+O");
        setToolTipText("Open a new file in this window");
    }

    public void run() {
        if (window.isModified()) {
            SavePromptAction spa = new SavePromptAction(window);
            spa.run();
            if (spa.isCancelled())
                return;
        }

        Shell shell = new Shell();
        FileDialog dialog = new FileDialog(shell, SWT.OPEN);

        if (lastDir == null) {
            if (window.getKenyaFile() != null) {
                lastDir = window.getKenyaFile().getDir();
                if (lastDir.length() == 0)
                    lastDir = null;
            }
        }
        if (lastDir != null)
            dialog.setFilterPath(lastDir);

        dialog.setFilterExtensions(new String[] { "*.k" });
        dialog.setText("Open Kenya file");
        if (dialog.open() != null) {
            lastDir = dialog.getFilterPath();
            File file = new File(dialog.getFilterPath(), dialog.getFileName());
            FileLoaderSaver fls = new FileLoaderSaver();
            fls.setPath(file.getAbsolutePath());
            window.setKenyaFile(fls);
            window.loadFromKenyaFile();
        }
    }
}