/* *******************************************************************************
 *   kenya                                                             *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 27-Aug-2004
 */
package kenya.sole.ui.editor.interpreter;

import kenya.sole.ui.editor.InterpreterPart;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.wellquite.kenya.stackMachine.IPointListener;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class BlueCarrotMover implements IPointListener {

    private final CarrotPainter ipl;

    private final StyledText text;

    private final InterpreterPart interpreter;

    private volatile int row = 0;

    private volatile int col = 0;

    private volatile int offset = 0;

    private volatile boolean paint = false;

    private volatile ISourceCodeLocation loc = null;

    private volatile IMethodScope lastMethod = null;

    public BlueCarrotMover(InterpreterPart intp) {
        this.ipl = intp.getCarrotPainter();
        this.text = intp.getEditorTextWidget();
        this.interpreter = intp;

    }

    public void pointReached(final Object data) {
        if (text.isDisposed()) return;
        if (!interpreter.getInterpreterStepMode()
                && !interpreter.getInterpreterTrackMode()
                && (!ipl.carrotsSet() || !ipl
                        .isCarrotAtOffset((ISourceCodeLocation) data))) return;
        if (Thread.currentThread().equals(text.getDisplay().getThread())) {
            synchronized (this) {
                loc = (ISourceCodeLocation) data;
                paint = false;
                if (ipl.isCarrotAtOffset(loc)) {
                    interpreter.getStackMachine().setStepMode(true);
                    interpreter.getInterpreterContinueButton().setEnabled(true);
                    paint = true;
                }
                if (interpreter.getInterpreterStepMode()) {
                    interpreter.getInterpreterContinueButton().setEnabled(true);
                    paint = true;
                }
                if (interpreter.getInterpreterTrackMode()) {
                    paint = true;
                }
                if (paint) {
                    row = loc.getLineNumber() - 1;
                    col = loc.getColumnNumber() - 1;
                    offset = text.getOffsetAtLine(row) + col;
                    ipl.setBlueCarrotOffset(offset);

                    if (interpreter.getStackMachine().getMethodScope() != lastMethod) {
                        interpreter.getInterpreterList().refresh();
                        interpreter.getInterpreterList().setSelection(
                                new StructuredSelection(interpreter
                                        .getInterpreterList().getElementAt(0)),
                                true);
                        lastMethod = interpreter.getStackMachine().getMethodScope();
                    }
                    interpreter.getInterpreterInspector().refresh();
                }
            }
        } else {
            text.getDisplay().syncExec(new Runnable() {

                public void run() {
                    pointReached(data);
                }
            });
        }
    }

}