/* *******************************************************************************
 *   kenya                                                             *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/
/*
 * Created on 19-Aug-2004
 */
package kenya.sole.ui.editor.interpreter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import kenya.sole.ui.editor.InterpreterPart;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.ui.IButtonManager;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

/**
 * @author Matthew Sackman (ms02)
 * @version 1
 */
public class CarrotPainter implements PaintListener {

    private final static int DIVISOR = 14;

    private final IButtonManager ibm;

    private final Image redCarrot;

    private final Image blueCarrot;

    private final int width;

    private final int height;

    private final StyledText text;

    private final List offsets = new ArrayList();
    
    private final Set locations = new HashSet();

    private volatile int blueCarrotOffset = 0;

    private volatile int scale = 0;

    private volatile int nScale = -1;

    private volatile int twidth = 0;

    private volatile int theight = 0;

    private volatile int offset;

    private volatile Point p;

    public CarrotPainter(InterpreterPart intp) {
    	  ibm = intp.getButtonManager();
        redCarrot = ibm.getImage(IButtonManager.REDCARROT);
        blueCarrot = ibm.getImage(IButtonManager.BLUECARROT);
        text = intp.getEditorTextWidget();
        width = redCarrot.getBounds().width;
        height = redCarrot.getBounds().height;
    }

    public synchronized void paintControl(PaintEvent e) {
        if (text.isDisposed() || !text.isVisible()) return;
        nScale = text.getFont().getFontData()[0].getHeight();
        if (scale != nScale) {
            scale = nScale;
            twidth = Math.max(1, width * scale / DIVISOR);
            theight = Math.max(1, height * scale / DIVISOR);
        }
        for (int idx = 0; idx < offsets.size(); idx++) {
            offset = ((Integer) offsets.get(idx)).intValue();
            p = text.getLocationAtOffset(offset);
            if (p.x > redCarrot.getBounds().width / 2)
                p.x -= redCarrot.getBounds().width / 2;
            else
                p.x = 0;

            if (p.x >= e.x && p.x <= e.x + e.width && p.y >= e.y
                    && p.y <= e.y + e.height)
                    e.gc.drawImage(redCarrot, 0, 0, width, height, p.x, p.y,
                            twidth, theight);
        }

        p = text.getLocationAtOffset(blueCarrotOffset);
        if (p.x > blueCarrot.getBounds().width / 2)
            p.x -= blueCarrot.getBounds().width / 2;
        else
            p.x = 0;

        if (p.x >= e.x && p.x <= e.x + e.width && p.y >= e.y
                && p.y <= e.y + e.height)
                e.gc.drawImage(blueCarrot, 0, 0, width, height, p.x, p.y,
                        twidth, theight);
    }

    public synchronized void addCarrot(int offset, ISourceCodeLocation loc) {
        if (offset < text.getCharCount() && offset >= 0) {
            offsets.add(new Integer(offset));
            locations.add(loc);
        }        
    }

    public synchronized void clear() {
        offsets.clear();
        locations.clear();
        blueCarrotOffset = 0;
    }

    public synchronized void removeCarrot(int offset, ISourceCodeLocation loc) {
        offsets.remove(new Integer(offset));
        locations.remove(loc);
    }

    public synchronized boolean isCarrotAtOffset(int offset) {
        return offsets.contains(new Integer(offset));
    }

    public synchronized boolean isCarrotAtOffset(ISourceCodeLocation loc) {
        return locations.contains(loc);
    }

    public synchronized void setBlueCarrotOffset(int offset) {
        blueCarrotOffset = offset;
        p = text.getSelection();
        if (p.x > offset || offset > p.y) {
            text.setSelection(offset);
            text.showSelection();
        }
        text.redraw();
    }
    
    public synchronized boolean carrotsSet() {
        return !offsets.isEmpty();
    }
}