/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Sep 16, 2004
 *
 */
package kenya.sole.ui.editor.interpreter;

import kenya.sole.ui.editor.InterpreterPart;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.wellquite.kenya.stackMachine.scope.IMethodScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedMethod;

/**
 * @author matthew
 *  
 */
public class InterpreterInspectorListLabelProvider implements ILabelProvider {

    private static final String CLOSEBRACKET = ")";

    private static final String COMMASPACE = ", ";

    private static final String SPACE = " ";

    private static final String OPENBRACKET = " (";

    private final InterpreterPart interpreter;

    public InterpreterInspectorListLabelProvider(InterpreterPart intp) {
        interpreter = intp;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        StringBuffer buf = new StringBuffer();
        if (element instanceof IMethodScope) {
            IStackMachineInformationProvider ismip = interpreter
                    .getBaseStackMachine();
            IInterpretedMethod method = ((IMethodScope) element)
                    .getCurrentMethod();
            IFunction function = ismip.lookupFunction(method.getName());
            buf.append(function.getName());
            buf.append(OPENBRACKET);
            IVariable[] vars = function.getArguments();
            for (int idx = 0; idx < vars.length; idx++) {
                buf.append(vars[idx].getType());
                buf.append(SPACE);
                buf.append(vars[idx].getName());
                buf.append(COMMASPACE);
            }
            if (buf.toString().endsWith(COMMASPACE)) {
                buf.delete(buf.length() - COMMASPACE.length(), buf.length());
            }
            buf.append(CLOSEBRACKET);
            return buf.toString();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

}