/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 10, 2004
 *
 */
package kenya.sole.ui.editor.kenya;


import java.util.Date;

import kenya.sole.ui.core.KenyaUI;
import kenya.sole.ui.editor.JavaPart;
import kenya.sole.ui.editor.KenyaPart;
import kenya.ui.syntaxhighlighting.KenyaLineStyler;
import mediator.subscription.MediationService;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class KenyaHelperThread extends AbstractJob {

    private final KenyaPart kenya;
    private final JavaPart java;
    private final String subID;

    public KenyaHelperThread(KenyaPart kp, JavaPart jp, String subID) {
        kenya = kp;
        java = jp;
        this.subID = subID;
    }

    private final long sleepPeriod = 500;

    public void execute() {

        try {
            while (!kenya.isVisible()) {
                try {
                    Thread.sleep(sleepPeriod);
                } catch (InterruptedException e) {
                }
            }

            if (KenyaUI.isExiting()) return;

            final StyledText text = kenya.getEditorTextWidget();
            Runnable reparseComments = new Runnable() {

                public void run() {
                    ( (KenyaLineStyler)kenya.getLineStyler() ).parseBlockComments(
                            text.getContent());
                    kenya.redraw();
                }
            };

            String oldText = "";
            String lastParseText = "";
            int oldCaretOffset = -1;
            boolean redraw = false;
            while (!KenyaUI.isExiting() && kenya.isVisible()) {
                String newText = kenya.getEditorText();
                
                if (new Date().getTime() > kenya.getLastKeyEvent().getTime() + 1000) {
                    if (!lastParseText.equals(newText) || kenya.reparse()) {
                    	
                    	MediationService.getInstance().provideSyncSubscriptionUpdate(subID);
                    	
                    	//this code was replaced by MediationService subscription
//                        try {
//                            ICheckedCode checkedCode = Mediator
//                                    .check(new StringReader(newText));
                    	// clearing the highlighting manager is now done in
                    	// KenyaPart.setCheckedCode
//                            kenya.getHighlightingManager().clear();
//                            kenya.setCheckedCode(checkedCode);
//                            if (!checkedCode.isErroredCode()) {
//                                java.setJavaCode(checkedCode.translate());
//                            } else {
//                                java.setJavaCode(null);
//                            }
//                            
//                            
//                        } catch (IOException e1) {
//                            System.err.println("Error whilst parsing code.");
//                        }
                    	// end replace
                        
                        lastParseText = newText;
                        kenya.reparse(false);
                        redraw = true;
                    }
                    int offset = kenya.getCaretOffset();
                    if (oldCaretOffset != offset) {
                        kenya.getHighlightingManager().showLinkedHighlights(
                                offset);
                        oldCaretOffset = offset;
                        redraw = true;
                    }

                    if (redraw) {
                        kenya.safeRedraw();
                        redraw = false;
                    }
                }

                if (!oldText.equals(newText)) {
                    oldText = newText;
                    text.getDisplay().syncExec(reparseComments);
                }

                try {
                    Thread.sleep(sleepPeriod);
                } catch (InterruptedException e) {
                }
            }

        } catch (SWTException e) {
            if (KenyaUI.isExiting()) {
            } else {
                throw e;
            }
        }
    }
}