/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 10, 2004
 *
 */
package kenya.sole.ui.event;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class EditorControlListener implements ControlListener {

    private final SashForm editorSash;

    private final StyledText numbers;

    private final StyledText text;

    public EditorControlListener(

    SashForm editorSash, StyledText numbers, StyledText text) {
        this.editorSash = editorSash;
        this.numbers = numbers;
        this.text = text;
    }

    public void controlMoved(ControlEvent e) {
        Point size = numbers.getSize();
        size.y -= (text.getHorizontalBar().getSize().y + editorSash.SASH_WIDTH);
        numbers.setSize(size);
    }

    public void controlResized(ControlEvent e) {
        Point size = numbers.getSize();
        size.y -= (text.getHorizontalBar().getSize().y + editorSash.SASH_WIDTH);
        numbers.setSize(size);
    }
}