/* *******************************************************************************
 *   Kenya                                                                       *
 *   Copyright (C) 2004 Tristan Allwood,                                         *
 *                 2004 Matthew Sackman                                          *
 *                                                                               *
 *   This program is free software; you can redistribute it and/or               *
 *   modify it under the terms of the GNU General Public License                 *
 *   as published by the Free Software Foundation; either version 2              *
 *   of the License, or (at your option) any later version.                      *
 *                                                                               *
 *   This program is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 *   GNU General Public License for more details.                                *
 *                                                                               *
 *   You should have received a copy of the GNU General Public License           *
 *   along with this program; if not, write to the Free Software                 *
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *                                                                               *
 *   The authors can be contacted by email at toa02@doc.ic.ac.uk                 *
 *                                             ms02@doc.ic.ac.uk                 *
 *                                                                               *
 *********************************************************************************/

/*
 * Created on Aug 10, 2004
 *
 */
package kenya.sole.ui.event;


import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import kenya.FileLoaderSaver;
import kenya.errors.KenyaInternalError;
import kenya.sole.ui.core.EditingWindow;
import kenya.sole.ui.editor.InterpreterPart;
import kenya.sole.ui.editor.JavaPart;
import kenya.sole.ui.editor.KenyaPart;
import kenya.ui.syntaxhighlighting.JavaLineStyler;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.Mediator;
import mediator.stackMachine.IStackMachineInformationProvider;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.TabFolder;
import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.ClosureScope;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;

/**
 * @author Matthew Sackman
 * @version 1
 */
public class TabSelectionAdapter extends SelectionAdapter {

    private static final String noTranslation = "Kenya code contains errors, "
            + "can not translate to Java.";

    private static final String noInterpretation = "Kenya code contains errors, "
            + "can not debug.";

    private final KenyaPart kenya;
    private final JavaPart java;
    private final InterpreterPart intp;

    private String oldJavaText = null;

    private String oldInterpreterText = null;

    private String lineDelimiter = null;

    private StringBuffer javaBuffer = new StringBuffer();

    public TabSelectionAdapter(KenyaPart k, JavaPart j, InterpreterPart i) {
        kenya = k;
        java = j;
        intp = i;
    }

    public void widgetSelected(SelectionEvent e) {
    	int index = ((TabFolder)e.widget).getSelectionIndex();
        if (index == EditingWindow.KENYATABINDEX) {
            if (intp.getStackMachine() != null) {
            	intp.getInterpreterTerminateButton().notifyListeners(
                        SWT.Selection, null);
            }
            if (java.getJavaCode() != null) {
            	java.getJavaTerminateButton().notifyListeners(SWT.Selection,
                        null);
            }
            return;
        } else if (index == EditingWindow.JAVATABINDEX) {
            if (intp.getStackMachine() != null) {
            	intp.getInterpreterTerminateButton().notifyListeners(
                        SWT.Selection, null);
            }
        } else if (index == EditingWindow.INTERPRETERTABINDEX) {
            if (java.getJavaCode() != null) {
            	java.getJavaTerminateButton().notifyListeners(SWT.Selection,
                        null);
            }
        }

        StyledText kenyaText = kenya.getEditorTextWidget();
        StyledText javaText = java.getEditorTextWidget();
        StyledText interpreterText = intp.getEditorTextWidget();

        if (javaText == null || kenyaText == null) return;

        if (lineDelimiter == null) lineDelimiter = javaText.getLineDelimiter();

        String text = kenyaText.getText();
        if (oldInterpreterText == null || !text.equals(oldInterpreterText)
                || oldJavaText == null || !text.equals(oldJavaText)) {

            try {
                ICheckedCode checkedCode = Mediator
                        .check(new StringReader(text));
                kenya.setCheckedCode(checkedCode);
                
                if (index == EditingWindow.JAVATABINDEX) {
                    if (oldJavaText == null || !text.equals(oldJavaText)) {

                        if (java.isJavaRunning()) { return; }

                        try {
                            Button javaExecuteButton = java
                                    .getJavaExecuteButton();
                            javaExecuteButton.setText("E&xecute Java");
                            if (checkedCode.isErroredCode()) {
                                javaText.setText(noTranslation);
                                ( (JavaLineStyler)java.getLineStyler() ).parseBlockComments(
                                        noTranslation);
                                java.rebuildLineNumbers();
                                java.setJavaCode(null);
                                java.setJavaClassName(null);
                                javaExecuteButton.setEnabled(false);
                            } else {
                            		java.setJavaCode(checkedCode.translate());
                                javaText.setRedraw(false);
                                StyledTextContent content = javaText
                                        .getContent();
                                content.setText("");
                                
                                BufferedReader javaReader = null;
                                FileLoaderSaver fls = kenya.getKenyaFile();

                                boolean getPlaceHeld = false;
                                String name = null;
                                IJavaCode code = java.getJavaCode();
                                
                                if (fls == null || fls.getName() == null
                                        || fls.getName().length() == 0) {
                                    if (code.isValidClassName(java
                                            .getJavaDefaultClassName())) {
                                        name = java.getJavaDefaultClassName();
                                    } else {
                                        getPlaceHeld = true;
                                    }
                                } else {
                                    String fileName = fls.getName();
                                    if (fileName.endsWith(".k"))
                                            fileName = fileName.substring(0,
                                                    fileName.length() - 2);
                                    if (fileName.length() > 1) {
                                        char prefix = fileName.charAt(0);
                                        fileName = new String("" + prefix)
                                                .toUpperCase()
                                                + fileName.substring(1);
                                    }
                                    if (code.isValidClassName(fileName)) {
                                        name = fileName;
                                    } else if (code.isValidClassName(java
                                            .getJavaDefaultClassName())) {
                                        name = java.getJavaDefaultClassName();
                                    } else {
                                        getPlaceHeld = true;
                                    }
                                }

                                if (getPlaceHeld) {
                                		java.setJavaClassName(null);
                                    javaReader = new BufferedReader(code
                                            .getPlaceHeldCode());
                                    javaExecuteButton.setEnabled(false);
                                } else {
//                                    name += ""
//                                            + Math.abs(SecureRandomNumber
//                                                    .nextInt());
                                		java.setJavaClassName(name);
                                    javaReader = new BufferedReader(code
                                            .getCode(name));
                                    javaExecuteButton.setEnabled(true);
                                }

                                javaBuffer.setLength(0);
                                String line = javaReader.readLine();
                                while (line != null) {
                                    javaBuffer.append(line);
                                    javaBuffer.append(lineDelimiter);
                                    line = javaReader.readLine();
                                }
                                javaReader.close();
                                content.setText(javaBuffer.toString());
                                ( (JavaLineStyler)java.getLineStyler() ).parseBlockComments(
                                        javaBuffer.toString());
                                java.rebuildLineNumbers();
                                javaText.setRedraw(true);
                            }
                        } catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        oldJavaText = text;
                    }
                } else if (index == EditingWindow.INTERPRETERTABINDEX) {

                    if (intp.getStackMachine() != null) { return; }

                    if (oldInterpreterText == null
                            || !text.equals(oldInterpreterText)) {
                    	intp.getInterpreterContinueButton().setEnabled(false);
                        if (checkedCode.isErroredCode()) {
                            interpreterText.setText(noInterpretation);
                            intp.rebuildLineNumbers();
                            intp.getInterpreterInterpretButton().setEnabled(
                                    false);
                            intp.getInterpreterStepModeButton().setEnabled(
                                    false);
                        } else {
                            interpreterText.setRedraw(false);
                            interpreterText.setText(kenyaText.getText());
                            intp.rebuildLineNumbers();
                            final IStackMachineInformationProvider ismip = checkedCode
                                    .getBaseStackMachine();
                            intp.setBaseStackMachine(ismip);
                            intp.getCarrotPainter().clear();
                            interpreterText.setRedraw(true);
                            intp.getInterpreterInterpretButton().setEnabled(
                                    true);
                            intp.getInterpreterStepModeButton().setEnabled(
                                    true);

                            StackMachine sm = intp.getStackMachine();
                            if (sm != null) {
                                sm.shutdown();
                                intp.setStackMachine(null);
                            }
                            sm = new StackMachine();
                            intp.getInterpreterStdOutText().setText("");
                            try {
                                IClosureScope scope = new ClosureScope();
                                ClosureMiscHelper.executeClosureInScope(scope,
                                        ismip.getPreInitClosure(), sm);
                            } catch (Throwable t) {
                            	intp.getInterpreterStdOutText()
                                        .append("" + t);
                            	intp.getInterpreterInterpretButton()
                                        .setEnabled(false);
                            	intp.getInterpreterStepModeButton()
                                        .setEnabled(false);
                            }
                        }
                        oldInterpreterText = text;
                    }
                }
            } catch (IOException e1) {
                e1.printStackTrace();
            } catch (KenyaInternalError e2) {
                System.err.println("SM compilation failed: ");
                e2.printStackTrace(System.err);
            }
        }
    }

}