/*
 * Decompiled with CFR 0.152.
 */
package LTSABPELPlugIn;

import LTSABPELPlugIn.XTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;

public class XmlEditor
extends JFrame
implements ActionListener {
    private XTree xTree;
    private JTextArea textArea;
    private JScrollPane jScroll;
    private JScrollPane jScrollRt;
    private JSplitPane splitPane;
    private JButton refreshButton;
    private WindowListener winClosing;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem saveItem;
    private JMenuItem exitItem;
    private JDialog verifyDialog;
    private JLabel question;
    private JButton okButton;
    private JButton cancelButton;
    private static final int FRAME_WIDTH = 600;
    private static final int FRAME_HEIGHT = 450;

    public XmlEditor(String title, ArrayList xmlText) throws ParserConfigurationException {
        this(title);
        this.textArea.setText(String.valueOf(String.valueOf((String)xmlText.get(0))).concat("\n"));
        for (int i = 1; i < xmlText.size(); ++i) {
            this.textArea.append(String.valueOf(String.valueOf((String)xmlText.get(i))).concat("\n"));
        }
        try {
            this.xTree.refresh(this.textArea.getText());
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            System.out.println(message);
        }
    }

    public XmlEditor(String title) throws ParserConfigurationException {
        super(title);
        ((Component)this).setBackground(Color.lightGray);
        this.getContentPane().setLayout(new BorderLayout());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        int screenHeight = dim.height;
        int screenWidth = dim.width;
        ((Component)this).setBounds((screenWidth - 600) / 2, (screenHeight - 450) / 2, 600, 450);
        this.fileMenu = new JMenu("File");
        this.newItem = new JMenuItem("New");
        this.newItem.addActionListener(new newMenuHandler());
        this.openItem = new JMenuItem("Open");
        this.openItem.addActionListener(new openMenuHandler());
        this.saveItem = new JMenuItem("Save");
        this.saveItem.addActionListener(new saveMenuHandler());
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.addActionListener(new exitMenuHandler());
        this.fileMenu.add(this.newItem);
        this.fileMenu.add(this.openItem);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.add(this.exitItem);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.verifyDialog = new JDialog(this, "Confirm Exit", true);
        ((Component)this.verifyDialog).setBounds((screenWidth - 200) / 2, (screenHeight - 100) / 2, 200, 100);
        this.question = new JLabel("Are you sure you want to exit?");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.verifyDialog.getContentPane().setLayout(new FlowLayout());
        this.verifyDialog.getContentPane().add(this.question);
        this.verifyDialog.getContentPane().add(this.okButton);
        this.verifyDialog.getContentPane().add(this.cancelButton);
        this.verifyDialog.hide();
        this.setDefaultCloseOperation(0);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.refreshButton.addActionListener(this);
        this.getContentPane().add((Component)this.refreshButton, "North");
        this.jScroll = new JScrollPane();
        this.jScrollRt = new JScrollPane();
        this.textArea = new JTextArea(200, 150);
        this.jScrollRt.getViewport().add(this.textArea);
        this.xTree = new XTree();
        this.xTree.getSelectionModel().setSelectionMode(1);
        this.xTree.setShowsRootHandles(true);
        this.xTree.setEditable(false);
        this.jScroll.getViewport().add(this.xTree);
        this.splitPane = new JSplitPane(1, this.jScroll, this.jScrollRt);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(200);
        Dimension minimumSize = new Dimension(200, 150);
        this.jScroll.setMinimumSize(minimumSize);
        this.jScrollRt.setMinimumSize(minimumSize);
        this.splitPane.setPreferredSize(new Dimension(400, 300));
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.validate();
        ((Component)this).setVisible(true);
        this.winClosing = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                XmlEditor.this.verifyDialog.show();
            }
        };
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Refresh")) {
            try {
                this.xTree.refresh(this.textArea.getText());
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                ex.printStackTrace();
            }
        } else if (ae.getActionCommand().equals("OK")) {
            XmlEditor.exit();
        } else if (ae.getActionCommand().equals("Cancel")) {
            this.verifyDialog.hide();
        }
    }

    public static void main(String[] args) {
        block7: {
            String fileName = "";
            ArrayList<String> xmlText = null;
            try {
                if (args.length > 0) {
                    fileName = args[0];
                    if (fileName.substring(fileName.indexOf(46)).equals(".xml")) {
                        String line;
                        BufferedReader reader = new BufferedReader(new FileReader(fileName));
                        xmlText = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            xmlText.add(line);
                        }
                        reader.close();
                        XmlEditor xmlEditor = new XmlEditor("XmlEditor 1.0", xmlText);
                    } else {
                        XmlEditor.help();
                    }
                    break block7;
                }
                XmlEditor xmlEditor = new XmlEditor("XmlEditor 1.0");
            }
            catch (FileNotFoundException fnfEx) {
                System.out.println(String.valueOf(String.valueOf(fileName)).concat(" was not found."));
                XmlEditor.exit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                XmlEditor.exit();
            }
        }
    }

    private static void help() {
        System.out.println("\nUsage: java XmlEditor filename.xml");
        System.exit(0);
    }

    public static void exit() {
        System.out.println("\nThank you for using XmlEditor 1.0");
        System.exit(0);
    }

    static {
        FRAME_WIDTH = 600;
        FRAME_HEIGHT = 450;
    }

    class XmlFileFilter
    extends FileFilter {
        XmlFileFilter(XmlEditor this$0) {
        }

        public boolean accept(File fobj) {
            if (fobj.isDirectory()) {
                return true;
            }
            return fobj.getName().endsWith(".xml");
        }

        public String getDescription() {
            return "*.xml";
        }
    }

    class exitMenuHandler
    implements ActionListener {
        exitMenuHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            XmlEditor.this.verifyDialog.show();
        }
    }

    class saveMenuHandler
    implements ActionListener {
        JFileChooser jfc = new JFileChooser();
        Container parent;
        int choice;

        saveMenuHandler() {
            this.jfc.setSize(400, 300);
            this.jfc.setFileFilter(new XmlFileFilter(XmlEditor.this));
            this.parent = XmlEditor.this.saveItem.getParent();
        }

        public void actionPerformed(ActionEvent ae) {
            block2: {
                this.choice = this.jfc.showSaveDialog(this.parent);
                if (this.choice != 0) break block2;
                String fileName = this.jfc.getSelectedFile().getAbsolutePath();
                try {
                    FileWriter writer = new FileWriter(fileName);
                    XmlEditor.this.textArea.write(writer);
                    writer.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                this.jfc.setCurrentDirectory(new File(fileName));
            }
        }
    }

    class openMenuHandler
    implements ActionListener {
        JFileChooser jfc = new JFileChooser();
        Container parent;
        int choice;

        openMenuHandler() {
            this.jfc.setSize(400, 300);
            this.jfc.setFileFilter(new XmlFileFilter(XmlEditor.this));
            this.parent = XmlEditor.this.openItem.getParent();
        }

        public void actionPerformed(ActionEvent ae) {
            block3: {
                this.choice = this.jfc.showOpenDialog(this.parent);
                if (this.choice != 0) break block3;
                String fileName = this.jfc.getSelectedFile().getAbsolutePath();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(fileName));
                    XmlEditor.this.textArea.setText(String.valueOf(String.valueOf(reader.readLine())).concat("\n"));
                    while ((line = reader.readLine()) != null) {
                        XmlEditor.this.textArea.append(String.valueOf(String.valueOf(line)).concat("\n"));
                    }
                    reader.close();
                    XmlEditor.this.xTree.refresh(XmlEditor.this.textArea.getText());
                }
                catch (Exception ex) {
                    String message = ex.getMessage();
                    ex.printStackTrace();
                }
                this.jfc.setCurrentDirectory(new File(fileName));
            }
        }
    }

    class newMenuHandler
    implements ActionListener {
        newMenuHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            XmlEditor.this.textArea.setText("");
            try {
                XmlEditor.this.xTree = new XTree();
                XmlEditor.this.xTree.getSelectionModel().setSelectionMode(1);
                XmlEditor.this.xTree.setShowsRootHandles(true);
                XmlEditor.this.xTree.setEditable(false);
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                ex.printStackTrace();
            }
        }
    }
}

