/*
 * Decompiled with CFR 0.152.
 */
package LTSABPELPlugIn;

import LTSABPELPlugIn.XTree;
import bpel2fsp.convert;
import com.ibm.bpws.model.BPWSProcess;
import com.ibm.cs.bpws.parser.BPWSParser;
import com.ibm.cs.bpws.parser.Validator;
import ic.doc.extension.LTSA;
import ic.doc.extension.LTSAButton;
import ic.doc.extension.LTSAPlugin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class bpelPlugIn
extends LTSAPlugin {
    Component o_scroll_panel;
    JEditorPane o_Panel;
    Font bpelEditorFont = new Font("Courier", 0, 20);
    LTSA x_ltsa;
    private LinkedList relabelLinkedList;
    private boolean IsEditList = false;
    private LinkedList CompositionList = null;
    private XTree xTree;
    private JTextArea textArea;
    private JTextArea validatetextArea;
    private JScrollPane jScroll;
    private JScrollPane jScrollLt;
    private JScrollPane jScrollRt;
    private JSplitPane splitPane;
    private JButton refreshButton;
    private Vector bpe4wsprocesstableRows;
    private JTable table;
    private JTable bpel4wsprocesstable;
    private MyAbstractTableModel dataModel;
    private String newFSPText;
    private JCheckBox newCheckBox;
    private JLabel actionlabel;
    private List oMenuList;
    private JMenuBar bpel4wsPluginMenuBar;
    private JScrollPane jScrollValidate;
    private BPWSParser BPEL4WSParser;
    private Validator BPEL4WSValidator;
    convert bpelconvert;
    private String CurrentBPELProcessName = "";
    private String fspspecpath = "";
    private List o_toolbar_buttons;
    private Boolean o_running;

    public bpelPlugIn() {
    }

    public bpelPlugIn(LTSA p_ltsa) {
        super(p_ltsa);
    }

    public void initialise() {
        try {
            this.CompositionList = new LinkedList();
            this.bpe4wsprocesstableRows = new Vector();
            this.BPEL4WSParser = new BPWSParser();
            this.BPEL4WSValidator = new Validator();
            this.relabelLinkedList = new LinkedList();
            this.relabelLinkedList.add("");
            this.dataModel = new MyAbstractTableModel(this);
            this.table = new JTable(this.dataModel);
            this.bpel4wsprocesstable = new JTable(new MyAbstractBPEL4WSTable(this));
            this.bpel4wsprocesstable.setUI(new MyAbstractBPEL4WSTableUI(this));
            TableColumn fspSpecColumn = this.table.getColumnModel().getColumn(1);
            Object[] values = new String[]{"item1", "item2", "item3"};
            JComboBox<String> renameComboBox = new JComboBox<String>(values);
            fspSpecColumn.setCellEditor(new MyComboBoxEditor(this, values));
            fspSpecColumn.setCellRenderer(new MyComboBoxRenderer(this, values));
            TableColumn fspHideColumn = this.table.getColumnModel().getColumn(2);
            this.newCheckBox = new JCheckBox();
            fspHideColumn.setCellEditor(new DefaultCellEditor(this.newCheckBox));
            this.jScroll = new JScrollPane();
            this.jScrollLt = new JScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
            this.jScrollRt = new JScrollPane();
            this.jScrollValidate = new JScrollPane();
            this.textArea = new JTextArea();
            this.validatetextArea = new JTextArea();
            this.validatetextArea.setEditable(false);
            this.jScrollRt.getViewport().add(this.textArea);
            this.jScrollValidate.getViewport().add(this.validatetextArea);
            this.xTree = new XTree();
            this.xTree.getSelectionModel().setSelectionMode(1);
            this.xTree.setShowsRootHandles(true);
            this.xTree.setEditable(true);
            this.jScroll.getViewport().add(this.xTree);
            JPanel XMLTreePanel = new JPanel();
            XMLTreePanel.setLayout(new BoxLayout(XMLTreePanel, 1));
            JLabel XMLTreelabel = new JLabel("XML Tree View");
            this.xTree.setPreferredSize(new Dimension(50, 50));
            XMLTreelabel.setLabelFor(this.xTree);
            XMLTreePanel.add(XMLTreelabel);
            XMLTreePanel.add(Box.createRigidArea(new Dimension(0, 5)));
            XMLTreePanel.add(this.jScroll);
            XMLTreePanel.setPreferredSize(new Dimension(50, 50));
            JToolBar panel = new JToolBar();
            JButton clearButton = new JButton("New");
            JButton refreshButton = new JButton("Refresh");
            JButton checkButton = new JButton("Check Source");
            JButton selectFSPButton = new JButton("Select Spec FSP");
            panel.add(clearButton);
            panel.add(refreshButton);
            panel.add(checkButton);
            panel.add(selectFSPButton);
            clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    bpelPlugIn.this.clearAll();
                }
            });
            selectFSPButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    bpelPlugIn.this.selectFSPSpec();
                }
            });
            refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        bpelPlugIn.this.xTree.refresh(bpelPlugIn.this.textArea.getText());
                        bpelPlugIn.this.runActionTranslate();
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage();
                        ex.printStackTrace();
                    }
                }
            });
            checkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        bpelPlugIn.this.validateBPEL4WS();
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage();
                        bpelPlugIn.this.validatetextArea.append("ERROR in validating BPEL4WS.\n");
                        bpelPlugIn.this.validatetextArea.append(message);
                    }
                }
            });
            JPanel EditorPane = new JPanel();
            EditorPane.setLayout(new BoxLayout(EditorPane, 1));
            JLabel Editorlabel = new JLabel("BPEL4WS");
            Editorlabel.setLabelFor(this.jScrollRt);
            EditorPane.add(Editorlabel);
            EditorPane.add(Box.createRigidArea(new Dimension(0, 5)));
            EditorPane.add(this.jScrollRt);
            EditorPane.add(Box.createRigidArea(new Dimension(0, 5)));
            EditorPane.add(panel);
            JPanel ValidatePane = new JPanel();
            ValidatePane.setLayout(new BoxLayout(ValidatePane, 1));
            JLabel Validatelabel = new JLabel("STATUS");
            Validatelabel.setLabelFor(this.jScrollValidate);
            ValidatePane.add(Validatelabel);
            ValidatePane.add(Box.createRigidArea(new Dimension(0, 5)));
            ValidatePane.add(this.jScrollValidate);
            JSplitPane horPane2 = new JSplitPane(0, EditorPane, ValidatePane);
            horPane2.setPreferredSize(new Dimension(200, 300));
            horPane2.setDividerLocation(500);
            JPanel listPane = new JPanel();
            listPane.setLayout(new BoxLayout(listPane, 1));
            JLabel label = new JLabel("ACTION LIST");
            this.actionlabel = new JLabel("No Specification selected.");
            this.actionlabel.setLabelFor(this.jScrollLt);
            listPane.add(label);
            listPane.add(Box.createRigidArea(new Dimension(0, 5)));
            listPane.add(this.actionlabel);
            listPane.add(Box.createRigidArea(new Dimension(0, 5)));
            listPane.add(this.jScrollLt);
            JPanel bpel4wsPane = new JPanel();
            bpel4wsPane.setLayout(new BoxLayout(bpel4wsPane, 1));
            JLabel label2 = new JLabel("Composition List");
            bpel4wsPane.add(label2);
            JToolBar bpel4wsPanebuttonpanel = new JToolBar();
            JButton AddButton = new JButton("Add");
            AddButton.addActionListener(new MyAddBPEL4WSListener());
            bpel4wsPanebuttonpanel.add(AddButton);
            JButton RemoveButton = new JButton("Remove");
            RemoveButton.addActionListener(new MyRemoveBPEL4WSListener());
            bpel4wsPanebuttonpanel.add(RemoveButton);
            JButton EditButton = new JButton("Edit");
            EditButton.addActionListener(new MyEditBPEL4WSListener());
            bpel4wsPanebuttonpanel.add(EditButton);
            JButton TranslateButton = new JButton("Translate");
            TranslateButton.addActionListener(new MyTranslateBPEL4WSListener());
            bpel4wsPanebuttonpanel.add(TranslateButton);
            bpel4wsPane.add(Box.createRigidArea(new Dimension(0, 5)));
            bpel4wsPane.add(Box.createRigidArea(new Dimension(0, 5)));
            bpel4wsPane.add(bpel4wsPanebuttonpanel);
            JScrollPane jScrollBPEL4WSList = new JScrollPane(this.bpel4wsprocesstable);
            bpel4wsPane.add(jScrollBPEL4WSList);
            JSplitPane leftPane = new JSplitPane(0, XMLTreePanel, listPane);
            leftPane.setDividerLocation(200);
            JSplitPane left2Pane = new JSplitPane(0, leftPane, bpel4wsPane);
            left2Pane.setDividerLocation(500);
            this.splitPane = new JSplitPane(1, left2Pane, horPane2);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setDividerLocation(200);
            this.splitPane.invalidate();
            listPane.invalidate();
            refreshButton = new JButton("Refresh");
            refreshButton.setBorder(BorderFactory.createRaisedBevelBorder());
            this.o_scroll_panel = this.splitPane;
            this.bpelconvert = new convert();
            this.o_toolbar_buttons = new ArrayList();
            this.createButtons();
            this.bpel4wsPluginMenuBar = new JMenuBar();
            JMenu FileMenu = new JMenu("File");
            ActionListener fileNewAL = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        bpelPlugIn.this.clearAll();
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage();
                        ex.printStackTrace();
                    }
                }
            };
            ActionListener fileOpenAL = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            };
            JMenuItem fileOpenMI = new JMenuItem("Open");
            fileOpenMI.addActionListener(fileOpenAL);
            FileMenu.add(fileOpenMI);
            FileMenu.add(new JMenuItem("Save BPEL4WS"));
            FileMenu.add(new JMenuItem("Close"));
            this.bpel4wsPluginMenuBar.add(FileMenu);
            JMenu newMenu = new JMenu("Tools");
            newMenu.add(new JMenuItem("Check"));
            this.bpel4wsPluginMenuBar.add(newMenu);
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }

    public boolean providesOpenFile() {
        return true;
    }

    public String getFileExtension() {
        return "bpel";
    }

    public boolean providesNewFile() {
        return true;
    }

    public boolean providesSaveFile() {
        return true;
    }

    public boolean addMenusToMenuBar() {
        return true;
    }

    public boolean useOwnMenuBar() {
        return true;
    }

    public boolean addMenuItems() {
        return true;
    }

    public String getName() {
        return "WS Compositions";
    }

    public boolean addAsTab() {
        return true;
    }

    public Component getComponent() {
        return this.o_scroll_panel;
    }

    public boolean addToolbarButtons() {
        return true;
    }

    public List getToolbarButtons() {
        return this.o_toolbar_buttons;
    }

    public Map getMenuItems() {
        HashMap<JMenuItem, String> x_items = new HashMap<JMenuItem, String>();
        JMenuItem x_item1 = new JMenuItem("Check Source");
        x_item1.addActionListener(new MyCheckActionListener());
        JMenuItem x_item2 = new JMenuItem("Build FSP");
        x_item2.addActionListener(new MyCompileActionListener());
        JMenuItem x_item3 = new JMenuItem("Build Action List");
        x_item3.addActionListener(new MyActionListActionListener());
        JMenuItem x_item4 = new JMenuItem("Build Tree");
        x_item3.addActionListener(new MyActionListActionListener());
        x_items.put(x_item1, "BPEL4WS Plugin");
        x_items.put(x_item2, "BPEL4WS Plugin");
        x_items.put(x_item3, "BPEL4WS Plugin");
        x_items.put(x_item4, "BPEL4WS Plugin");
        return x_items;
    }

    private void addBPEL4WSProcessVectorToList(String processname, String path, boolean Compose) {
        this.validatetextArea.setText(this.CurrentBPELProcessName);
        DefaultTableModel _model = new DefaultTableModel();
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("No");
        columnNames.add("Process");
        columnNames.add("Location");
        columnNames.add("Compose");
        Vector table = new Vector();
        Vector<Object> row = new Vector<Object>();
        int processno = this.bpe4wsprocesstableRows.size() + 1;
        String processstr = "".concat(String.valueOf(String.valueOf(processno)));
        row.add(processstr);
        row.add(processname);
        row.add(path);
        row.add(new Boolean(Compose));
        this.bpe4wsprocesstableRows.add(row);
        _model.setDataVector(this.bpe4wsprocesstableRows, columnNames);
        this.bpel4wsprocesstable.setModel(_model);
    }

    private void removeBPEL4WSProcessVectorFromList(String processname) {
        this.validatetextArea.setText(String.valueOf(String.valueOf(new StringBuffer("Removing ").append(processname).append(" from composition list."))));
        DefaultTableModel _model = new DefaultTableModel();
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("No");
        columnNames.add("Process");
        columnNames.add("Location");
        columnNames.add("Compose");
        this.bpe4wsprocesstableRows.remove(this.bpel4wsprocesstable.getSelectedRow());
        _model.setDataVector(this.bpe4wsprocesstableRows, columnNames);
        this.bpel4wsprocesstable.setModel(_model);
    }

    public void clearAll() {
        this.validatetextArea.setText("");
        this.textArea.setText("");
        this.xTree.refresh("<xml><blank></blank></xml>");
        Object[][] newData = new Object[1][3];
        String[] names = new String[]{"Action", "Map To", "Hide", "Set Fault"};
        newData[0][0] = "";
        newData[0][1] = "";
        newData[0][2] = new Boolean(false);
        newData[0][3] = new Boolean(false);
        this.dataModel.setNewData(newData);
    }

    private boolean validateBPEL4WS() {
        this.validatetextArea.setText("");
        BPWSParser.setVerbose((boolean)true);
        ByteArrayInputStream baos = new ByteArrayInputStream(this.textArea.getText().getBytes());
        BPWSProcess newProcess = BPWSParser.readBPWS((InputStream)baos);
        Map testmap = Validator.validateBPWS((BPWSProcess)newProcess);
        this.validatetextArea.append(testmap.toString());
        return testmap.isEmpty();
    }

    private void runActionTranslate() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.bpelconvert.loadBPEL(this.textArea.getText(), false);
            this.bpelconvert.setFSPOutput(baos);
            this.bpelconvert.setOutput(os);
            this.bpelconvert.runAnalysis();
            this.bpelconvert.translateToFSP(false);
            this.CurrentBPELProcessName = this.bpelconvert.strBPELProcessName;
            this.table.removeAll();
            Object[][] newData = new Object[this.bpelconvert.getActionList().size()][4];
            int x = 0;
            Iterator I = this.bpelconvert.getActionList().iterator();
            while (I.hasNext()) {
                newData[x][0] = I.next();
                newData[x][1] = "";
                newData[x][2] = new Boolean(false);
                newData[x][3] = new Boolean(false);
                ++x;
            }
            String[] names = new String[]{"Action", "Map To", "Hide", "Set Fault"};
            this.dataModel.setNewData(newData);
            if (this.fspspecpath.length() > 0) {
                this.extractFSPSpecLabels();
                TableColumn fspSpecColumn = this.table.getColumnModel().getColumn(1);
                JComboBox<Object> renameComboBox = new JComboBox<Object>(this.relabelLinkedList.toArray());
                fspSpecColumn.setCellEditor(new MyComboBoxEditor(this, this.relabelLinkedList.toArray()));
                fspSpecColumn.setCellRenderer(new MyComboBoxRenderer(this, this.relabelLinkedList.toArray()));
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }

    private void selectFSPSpec() {
        try {
            FileDialog fileDialog = new FileDialog((Frame)new JFrame(), "Open FSP Spec File", 0);
            fileDialog.show();
            this.fspspecpath = String.valueOf(String.valueOf(fileDialog.getDirectory())).concat(String.valueOf(String.valueOf(fileDialog.getFile())));
            this.actionlabel.setText("Match FSP: ".concat(String.valueOf(String.valueOf(fileDialog.getFile()))));
            this.extractFSPSpecLabels();
            this.runActionTranslate();
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }

    private void extractFSPSpecLabels() {
        try {
            if (this.fspspecpath.length() > 0) {
                File file = new File(this.fspspecpath);
                BufferedReader read = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String s = read.readLine();
                while (s != null) {
                    String actionstr;
                    char actionchar;
                    int actionend;
                    s = read.readLine();
                    int actionstart = s.indexOf("->");
                    if (actionstart <= 0 || (actionend = s.indexOf("->", actionstart + 2)) <= 0 || !Character.isLowerCase(actionchar = (actionstr = s.substring(actionstart + 2, actionend).trim()).charAt(0))) continue;
                    this.validatetextArea.append(String.valueOf(String.valueOf(actionstr)).concat("\n"));
                    if (this.relabelLinkedList.indexOf(actionstr) >= 1) continue;
                    this.relabelLinkedList.add(actionstr);
                    this.validatetextArea.append(String.valueOf(String.valueOf(new StringBuffer("SIZE: ").append(this.relabelLinkedList.size()).append("\n"))));
                }
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }

    public void saveFile(FileOutputStream fileOutputStream) {
        try {
            fileOutputStream.write(this.textArea.getText().getBytes());
            fileOutputStream.close();
        }
        catch (Exception E) {
            E.getMessage();
        }
    }

    public void openFile(File file) {
        try {
            BufferedReader read = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String s = read.readLine();
            this.textArea.setText("");
            while (s != null) {
                this.textArea.append(String.valueOf(String.valueOf(s)).concat("\n"));
                s = read.readLine();
            }
            if (this.validateBPEL4WS()) {
                this.xTree.refresh(this.textArea.getText());
                this.runActionTranslate();
                if (!this.IsEditList) {
                    this.addBPEL4WSProcessVectorToList(this.CurrentBPELProcessName, file.getAbsolutePath(), false);
                }
                this.IsEditList = false;
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }

    public void newFile() {
        this.clearAll();
    }

    private void compileToFSP(boolean clearoutput) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.x_ltsa = this.getLTSA();
            if (clearoutput) {
                this.x_ltsa.clearOutput();
            }
            this.x_ltsa.swapto("Output");
            this.x_ltsa.outln("BPEL4WS 1.0 FSP Translator - hf1@doc.ic.ac.uk");
            this.x_ltsa.outln("Loading BPEL...");
            this.bpelconvert.loadBPEL(this.textArea.getText(), false);
            this.bpelconvert.setFSPOutput(baos);
            this.bpelconvert.setOutput(os);
            this.x_ltsa.outln("Running Analysis...");
            this.bpelconvert.runAnalysis();
            this.x_ltsa.outln(os.toString());
            this.x_ltsa.outln("Translating...");
            TableModel tempTableModel = this.table.getModel();
            for (int x = 0; x < tempTableModel.getRowCount(); ++x) {
                if (tempTableModel.getValueAt(x, 0).toString().length() <= 0 || !tempTableModel.getValueAt(x, 3).toString().equals("true")) continue;
                baos.write("const FAULTINVOKE3 = 0".getBytes());
            }
            this.bpelconvert.translateToFSP(false);
            baos.write("\n\n".toString().getBytes());
            baos.write(String.valueOf(String.valueOf(new StringBuffer("||").append(this.bpelconvert.strBPELProcessName).append("_BPELArchitectureModel = ").append(this.bpelconvert.strBPELProcessName).append("_BPELModel"))).toString().getBytes());
            int relabelcounter = 0;
            for (int x = 0; x < tempTableModel.getRowCount(); ++x) {
                if (tempTableModel.getValueAt(x, 1).toString().length() <= 0 || !tempTableModel.getValueAt(x, 2).toString().equals("false")) continue;
                if (relabelcounter == 0) {
                    baos.write(" / {".toString().getBytes());
                }
                if (relabelcounter > 0) {
                    baos.write(",".toString().getBytes());
                }
                baos.write(tempTableModel.getValueAt(x, 1).toString().getBytes());
                baos.write("/".toString().getBytes());
                baos.write(tempTableModel.getValueAt(x, 0).toString().getBytes());
                ++relabelcounter;
            }
            if (relabelcounter > 0) {
                baos.write("}".toString().getBytes());
            }
            int hiddencounter = 0;
            for (int x = 0; x < tempTableModel.getRowCount(); ++x) {
                if (!tempTableModel.getValueAt(x, 2).toString().equals("true")) continue;
                if (hiddencounter == 0) {
                    baos.write(" \\ {".toString().getBytes());
                }
                if (hiddencounter > 0) {
                    baos.write(",".toString().getBytes());
                }
                baos.write(tempTableModel.getValueAt(x, 0).toString().getBytes());
                ++hiddencounter;
            }
            if (hiddencounter > 0) {
                baos.write("}".toString().getBytes());
            }
            baos.write(".".toString().getBytes());
            if (this.fspspecpath.length() > 0) {
                baos.write("\n\n".toString().getBytes());
                File file = new File(this.fspspecpath);
                BufferedReader read = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String s = read.readLine();
                while (s != null) {
                    baos.write(String.valueOf(String.valueOf(s)).concat("\n").toString().getBytes());
                    s = read.readLine();
                }
                baos.write("\n\n".toString().getBytes());
                baos.write("||Abs_Process_SPEC = BPELArchitectureModel.".toString().getBytes());
                baos.write("\n\n".toString().getBytes());
                baos.write("deterministic ||DetA = Abs_Process_SPEC \\ {endAction}.\n".toString().getBytes());
                baos.write("property ||A = DetA.\n".toString().getBytes());
                baos.write("||CheckBPEL = (A || Abs_Process_BPEL ).".toString().getBytes());
                baos.write("\n\n".toString().getBytes());
                baos.write("deterministic ||DetB = Abs_Process_BPEL.\n".toString().getBytes());
                baos.write("property ||B = DetB.\n".toString().getBytes());
                baos.write("||CheckMSC = (B || Abs_Process_SPEC ).".toString().getBytes());
            }
            if (clearoutput) {
                this.x_ltsa.getInputPane().setText("");
            }
            this.x_ltsa.outln("Writing FSP...");
            if (clearoutput) {
                this.x_ltsa.getInputPane().setText(baos.toString());
            } else {
                ByteArrayOutputStream temp = new ByteArrayOutputStream();
                temp.write(this.x_ltsa.getInputPane().getText().getBytes());
                temp.write(baos.toString().getBytes());
                this.x_ltsa.getInputPane().setText(temp.toString());
            }
            this.x_ltsa.outln("Finished.");
            this.x_ltsa.swapto("Edit");
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }

    private void addCompositionModel() {
        int loop = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        try {
            this.x_ltsa = this.getLTSA();
            baos.write(this.bpelconvert.buildConnectorModels().getBytes());
            baos.write("\n\n||CompositionArchitecture = (".toString().getBytes());
            Iterator I = ((AbstractList)this.bpe4wsprocesstableRows).iterator();
            while (I.hasNext()) {
                if (!I.hasNext()) continue;
                Vector targetRow = (Vector)I.next();
                String processname = (String)targetRow.get(1);
                processname = String.valueOf(String.valueOf(processname)).concat("_BPELArchitectureModel");
                if (loop > 0) {
                    baos.write(" || ".toString().getBytes());
                }
                baos.write(processname.getBytes());
                ++loop;
            }
            baos.write(").".toString().getBytes());
            temp.write(this.x_ltsa.getInputPane().getText().getBytes());
            temp.write(baos.toString().getBytes());
            this.x_ltsa.getInputPane().setText(temp.toString());
            this.x_ltsa.swapto("Edit");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createButtons() {
        ImageIcon x_icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/LTSABPELPlugIn/web.gif"));
        LTSAButton x_button = new LTSAButton(x_icon, "Compile to FSP", (ActionListener)new MyCompileActionListener());
        this.o_toolbar_buttons.add(x_button);
    }

    class MyAddBPEL4WSListener
    implements ActionListener {
        MyAddBPEL4WSListener() {
        }

        public void actionPerformed(ActionEvent p_e) {
            FileDialog fileDialog = new FileDialog((Frame)new JFrame(), "Add BPEL4WS Process", 0);
            fileDialog.show();
            if (String.valueOf(String.valueOf(fileDialog.getDirectory())).concat(String.valueOf(String.valueOf(fileDialog.getFile()))) != null) {
                File addprocessfile = new File(String.valueOf(String.valueOf(fileDialog.getDirectory())).concat(String.valueOf(String.valueOf(fileDialog.getFile()))));
                bpelPlugIn.this.openFile(addprocessfile);
            }
        }
    }

    class MyTranslateBPEL4WSListener
    implements ActionListener {
        MyTranslateBPEL4WSListener() {
        }

        public void actionPerformed(ActionEvent p_e) {
            bpelPlugIn.this.x_ltsa = bpelPlugIn.this.getLTSA();
            bpelPlugIn.this.x_ltsa.getInputPane().setText("");
            Iterator I = ((AbstractList)bpelPlugIn.this.bpe4wsprocesstableRows).iterator();
            while (I.hasNext()) {
                if (!I.hasNext()) continue;
                Vector targetRow = (Vector)I.next();
                File addprocessfile = new File((String)targetRow.get(2));
                bpelPlugIn.this.IsEditList = true;
                bpelPlugIn.this.openFile(addprocessfile);
                bpelPlugIn.this.compileToFSP(false);
            }
            bpelPlugIn.this.addCompositionModel();
        }
    }

    class MyRemoveBPEL4WSListener
    implements ActionListener {
        MyRemoveBPEL4WSListener() {
        }

        public void actionPerformed(ActionEvent p_e) {
            bpelPlugIn.this.removeBPEL4WSProcessVectorFromList("");
        }
    }

    class MyEditBPEL4WSListener
    implements ActionListener {
        MyEditBPEL4WSListener() {
        }

        public void actionPerformed(ActionEvent p_e) {
            Vector targetRow = (Vector)bpelPlugIn.this.bpe4wsprocesstableRows.get(bpelPlugIn.this.bpel4wsprocesstable.getSelectedRow());
            bpelPlugIn.this.validatetextArea.setText((String)targetRow.get(0));
            File addprocessfile = new File((String)targetRow.get(2));
            bpelPlugIn.this.IsEditList = true;
            bpelPlugIn.this.openFile(addprocessfile);
        }
    }

    class MyCompileActionListener
    implements ActionListener {
        MyCompileActionListener() {
        }

        public void actionPerformed(ActionEvent p_e) {
            bpelPlugIn.this.compileToFSP(true);
        }
    }

    class MyActionListActionListener
    implements ActionListener {
        MyActionListActionListener() {
        }

        public void actionPerformed(ActionEvent p_e) {
            bpelPlugIn.this.runActionTranslate();
        }
    }

    class MyCheckActionListener
    implements ActionListener {
        MyCheckActionListener() {
        }

        public void actionPerformed(ActionEvent p_e) {
            bpelPlugIn.this.validateBPEL4WS();
        }
    }

    public class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor(bpelPlugIn this$0, Object[] items) {
            super(new JComboBox<Object>(items));
        }
    }

    public class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public MyComboBoxRenderer(bpelPlugIn this$0, Object[] items) {
            super(items);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }

    class MyAbstractBPEL4WSTable
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"No", "Process", "Location", "Compose"};
        public Object[][] data = new Object[][]{{"", "", "", new Boolean(false)}};

        MyAbstractBPEL4WSTable(bpelPlugIn this$0) {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public void setNewData(Object[][] newData) {
            this.data = newData;
            this.fireTableStructureChanged();
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print(String.valueOf(String.valueOf(new StringBuffer("    row ").append(i).append(":"))));
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  ".concat(String.valueOf(String.valueOf(this.data[i][j]))));
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }

    class MyAbstractBPEL4WSTableUI
    extends BasicTableUI {
        MyAbstractBPEL4WSTableUI(bpelPlugIn this$0) {
        }
    }

    class MyAbstractTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Action", "Map To", "Hide", "Set Fault"};
        public Object[][] data = new Object[][]{{"", "", new Boolean(false), new Boolean(false)}};

        MyAbstractTableModel(bpelPlugIn this$0) {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public void setNewData(Object[][] newData) {
            this.data = newData;
            this.fireTableStructureChanged();
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print(String.valueOf(String.valueOf(new StringBuffer("    row ").append(i).append(":"))));
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  ".concat(String.valueOf(String.valueOf(this.data[i][j]))));
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

